/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pdfbox.extensions.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.pdfbox.extensions.elements.CellElement;
import org.eclipse.chemclipse.pdfbox.extensions.settings.TextOption;

public class PDTable {
    private static final Logger logger = Logger.getLogger(PDTable.class);
    private int startIndex = 0;
    private int stopIndex = 0;
    private int defaultBorder;
    private int indexHeader = -1;
    private List<List<CellElement>> headerRows = new ArrayList<List<CellElement>>();
    private List<List<String>> dataRows = new ArrayList<List<String>>();
    private TextOption textOption = TextOption.NONE;

    public PDTable() {
        this(CellElement.BORDER_ALL);
    }

    public PDTable(int defaultBorder) {
        this.nextHeaderRow();
        this.defaultBorder = defaultBorder;
    }

    public void setTextOption(TextOption textOption) {
        this.textOption = textOption;
    }

    public void nextHeaderRow() {
        this.headerRows.add(new ArrayList());
        this.indexHeader = this.headerRows.size() - 1;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public void setStopIndex(int stopIndex) {
        this.stopIndex = stopIndex;
    }

    public int getNumberHeaderRows() {
        return this.headerRows.size();
    }

    public int getNumberDataRows() {
        return this.dataRows.size();
    }

    public void addColumn(String title, float columnWidth) {
        this.addColumn(new CellElement(title, columnWidth, this.defaultBorder));
    }

    public void addColumn(CellElement tableCell) {
        List<CellElement> titleRow = this.headerRows.get(this.indexHeader);
        titleRow.add(tableCell);
    }

    public List<List<CellElement>> getHeader() {
        return this.headerRows;
    }

    public void addDataRow(List<String> row) {
        this.dataRows.add(row);
        this.stopIndex = this.getNumberDataRows();
    }

    public List<CellElement> getDataRow(int i) {
        ArrayList<CellElement> rowCells = new ArrayList<CellElement>();
        if (i >= 0 && i < this.dataRows.size()) {
            List<String> row = this.dataRows.get(i);
            int j = 0;
            while (j < row.size()) {
                float width = this.headerRows.get(this.indexHeader).get(j).getMaxWidth();
                rowCells.add(new CellElement(row.get(j), width, this.defaultBorder).setTextOption(this.textOption));
                ++j;
            }
        }
        return rowCells;
    }

    public float getWidth() {
        float width = 0.0f;
        for (CellElement tableCell : this.headerRows.get(this.indexHeader)) {
            width += tableCell.getMaxWidth();
        }
        return width;
    }

    public boolean isValid() {
        int columns = this.headerRows.get(this.indexHeader).size();
        for (List<String> dataRow : this.dataRows) {
            if (dataRow.size() == columns) continue;
            logger.warn((Object)("Row size not equals columns size: " + dataRow.size() + " - " + columns));
            return false;
        }
        return true;
    }
}

