/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.peak;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.support.settings.FileSettingProperty;
import org.eclipse.chemclipse.support.settings.SystemSettings;
import org.eclipse.chemclipse.support.settings.SystemSettingsStrategy;

@SystemSettings(value=SystemSettingsStrategy.NONE)
public class PeakExportSettings {
    public static final String VARIABLE_CHROMATOGRAM_NAME = "{chromatogram_name}";
    public static final String VARIABLE_EXTENSION = "{extension}";
    @JsonProperty(value="Export Folder", defaultValue="")
    @FileSettingProperty(onlyDirectory=true)
    private File exportFolder;
    @JsonProperty(value="Filename", defaultValue="{chromatogram_name}{extension}")
    private String filenamePattern = "{chromatogram_name}{extension}";

    @JsonIgnore
    public File getExportFileName(String extension, IChromatogram<?> chromatogram) {
        File folder = this.getExportFolder();
        String pattern = this.getFilenamePattern();
        String replaced = pattern.replace(VARIABLE_CHROMATOGRAM_NAME, chromatogram.getName()).replace(VARIABLE_EXTENSION, extension);
        return new File(folder, replaced);
    }

    public File getExportFolder() {
        return this.exportFolder;
    }

    public void setExportFolder(File exportFolder) {
        this.exportFolder = exportFolder;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }
}

