/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.core.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.TargetCombinedComparator;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationResults;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.IPeakIdentificationResults;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakIdentificationResults;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationResult;
import org.eclipse.chemclipse.model.implementation.IdentificationResults;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.core.support.NISTIdentificationTarget;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Compound;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Compounds;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Hit;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.NistResultFileParser;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.HLMFilenameFilter;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.IExtendedRuntimeSupport;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.INistSupport;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.RuntimeSupportFactory;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.INistSettings;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.PeakIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.msd.model.implementation.PeakIdentificationResult;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public class Identifier {
    private static final Logger logger = Logger.getLogger(Identifier.class);
    private static final String MSL_CONVERTER_ID = "org.eclipse.chemclipse.msd.converter.supplier.amdis.massspectrum.msl";
    private static final String MSP_CONVERTER_ID = "org.eclipse.chemclipse.msd.converter.supplier.amdis.massspectrum.msp";
    private static final String DESCRIPTION = "NIST Peak Identifier";
    private static final String LIBRARY = "NIST";
    private static final String COMPOUND_IN_LIB_FACTOR = "InLib Factor: ";
    private final TargetCombinedComparator targetCombinedComparator = new TargetCombinedComparator(SortOrder.DESC);
    private static final String PROCESS_ID = "ID-";
    private static final String BACKUP_CONTROL_EXTENSION = ".openchrom.bak";

    public IMassSpectra runMassSpectrumIdentification(List<IScanMSD> massSpectrumList, MassSpectrumIdentifierSettings massSpectrumIdentifierSettings, IProgressMonitor monitor) throws FileNotFoundException {
        IdentificationResults identificationResults = new IdentificationResults();
        MassSpectra massSpectra = new MassSpectra();
        File nistFolder = PreferenceSupplier.getNistInstallationFolder();
        IStatus status = PreferenceSupplier.validateLocation(nistFolder);
        if (status.isOK()) {
            IExtendedRuntimeSupport runtimeSupport = RuntimeSupportFactory.getRuntimeSupport(nistFolder);
            this.setNumberOfTargetsToReport(runtimeSupport, massSpectrumIdentifierSettings.getNumberOfTargets(), monitor);
            Map<String, String> identifierTable = this.setMassSpectrumIdentifier(massSpectrumList);
            logger.info((Object)"Backup control files.");
            this.backupControlFiles(runtimeSupport);
            logger.info((Object)"Clean files.");
            this.cleanFiles(runtimeSupport, monitor);
            try {
                logger.info((Object)"Get the mass spectra.");
                massSpectra = this.getMassSpectra(massSpectrumList);
                if (massSpectra.size() > 0) {
                    int numberOfUnknownEntriesToProcess = massSpectra.size();
                    logger.info((Object)("Process: " + numberOfUnknownEntriesToProcess));
                    runtimeSupport.getNistSupport().setNumberOfUnknownEntriesToProcess(numberOfUnknownEntriesToProcess);
                    logger.info((Object)"Prepare");
                    this.prepareFiles(runtimeSupport, (IMassSpectra)massSpectra, monitor);
                    long maxProcessTime = (long)((double)massSpectrumIdentifierSettings.getTimeoutInMinutes() * 60000.0);
                    logger.info((Object)("Max Process time: " + maxProcessTime));
                    logger.info((Object)"Run Identification");
                    Compounds compounds = this.runNistApplication(runtimeSupport, maxProcessTime, monitor);
                    logger.info((Object)"Assign Compounds");
                    identificationResults = this.assignMassSpectrumCompounds(compounds.getCompounds(), massSpectrumList, (IIdentificationResults)identificationResults, massSpectrumIdentifierSettings, identifierTable, monitor);
                }
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
            }
            catch (IOException e) {
                logger.warn((Object)e);
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
            }
            this.resetMassSpectrumIdentifier(massSpectrumList, identifierTable);
            this.cleanFiles(runtimeSupport, monitor);
            this.restoreControlFiles(runtimeSupport);
        }
        return massSpectra;
    }

    public IPeakIdentificationResults runPeakIdentification(List<? extends IPeakMSD> peaks, PeakIdentifierSettings peakIdentifierSettings, IProcessingInfo<?> processingInfo, IProgressMonitor monitor) throws FileNotFoundException {
        PeakIdentificationResults identificationResults = new PeakIdentificationResults();
        File nistFolder = PreferenceSupplier.getNistInstallationFolder();
        IStatus status = PreferenceSupplier.validateLocation(nistFolder);
        if (status.isOK()) {
            IExtendedRuntimeSupport runtimeSupport = RuntimeSupportFactory.getRuntimeSupport(nistFolder);
            this.setNumberOfTargetsToReport(runtimeSupport, peakIdentifierSettings.getNumberOfTargets(), monitor);
            Map<String, String> identifierTable = this.setPeakIdentifier(peaks);
            this.backupControlFiles(runtimeSupport);
            this.cleanFiles(runtimeSupport, monitor);
            try {
                IMassSpectra massSpectra = this.getMassSpectraFromPeakList(peaks);
                if (massSpectra.size() > 0) {
                    int numberOfUnknownEntriesToProcess = massSpectra.size();
                    runtimeSupport.getNistSupport().setNumberOfUnknownEntriesToProcess(numberOfUnknownEntriesToProcess);
                    this.prepareFiles(runtimeSupport, massSpectra, monitor);
                    long maxProcessTime = (long)((double)peakIdentifierSettings.getTimeoutInMinutes() * 60000.0);
                    Compounds compounds = this.runNistApplication(runtimeSupport, maxProcessTime, monitor);
                    identificationResults = this.assignPeakCompounds(compounds, peaks, (IPeakIdentificationResults)identificationResults, peakIdentifierSettings, identifierTable, processingInfo, monitor);
                }
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The peaks couldn't be identified, caused by a file is not writeable exception.");
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The peaks couldn't be identified, caused by a IO exception.");
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The peaks couldn't be identified, caused the converter to write the mass spectrum was not available.");
            }
            this.resetPeakIdentifier(peaks, identifierTable);
            this.cleanFiles(runtimeSupport, monitor);
            this.restoreControlFiles(runtimeSupport);
        }
        return identificationResults;
    }

    public void openNistForPeakIdentification(List<IPeakMSD> peaks, INistSettings nistSettings, IProgressMonitor monitor) throws FileNotFoundException {
        IMassSpectra massSpectra = this.getMassSpectraFromPeakList(peaks);
        this.openNistForMassSpectrumIdentification(massSpectra, nistSettings, monitor);
    }

    public void openNistForMassSpectrumIdentification(IMassSpectra massSpectra, INistSettings nistSettings, IProgressMonitor monitor) throws FileNotFoundException {
        File nistFolder = PreferenceSupplier.getNistInstallationFolder();
        IStatus status = PreferenceSupplier.validateLocation(nistFolder);
        if (status.isOK()) {
            IExtendedRuntimeSupport runtimeSupport = RuntimeSupportFactory.getRuntimeSupport(nistFolder);
            File file = new File(String.valueOf(runtimeSupport.getApplicationPath()) + File.separator + "openchrom-unknown.msp");
            List<IScanMSD> massSpectrumList = this.getMassSpectra(massSpectra);
            Map<String, String> identifierTable = this.setMassSpectrumIdentifier(massSpectrumList);
            this.backupControlFiles(runtimeSupport);
            this.cleanFiles(runtimeSupport, monitor);
            this.prepareMSPFile(file, massSpectra, monitor);
            this.openNistApplication(runtimeSupport, monitor);
            this.resetMassSpectrumIdentifier(massSpectrumList, identifierTable);
            this.cleanFiles(runtimeSupport, monitor);
            this.restoreControlFiles(runtimeSupport);
        }
    }

    private Map<String, String> setMassSpectrumIdentifier(List<IScanMSD> massSpectrumList) {
        HashMap<String, String> identifierTable = new HashMap<String, String>();
        int id = 1;
        for (IScanMSD massSpectrum : massSpectrumList) {
            this.setIdentifier(massSpectrum, id++, identifierTable);
        }
        return identifierTable;
    }

    private void resetMassSpectrumIdentifier(List<IScanMSD> massSpectrumList, Map<String, String> identifierTable) {
        for (IScanMSD massSpectrum : massSpectrumList) {
            this.resetIdentifier(massSpectrum, identifierTable);
        }
    }

    private IMassSpectra getMassSpectra(List<IScanMSD> massSpectrumList) {
        MassSpectra massSpectra = new MassSpectra();
        for (IScanMSD massSpectrum : massSpectrumList) {
            massSpectra.addMassSpectrum(massSpectrum);
        }
        return massSpectra;
    }

    private List<IScanMSD> getMassSpectra(IMassSpectra massSpectra) {
        ArrayList<IScanMSD> massSpectrumList = new ArrayList<IScanMSD>();
        int i = 1;
        while (i <= massSpectra.size()) {
            massSpectrumList.add(massSpectra.getMassSpectrum(i));
            ++i;
        }
        return massSpectrumList;
    }

    private IMassSpectra getMassSpectraFromPeakList(List<? extends IPeakMSD> peaks) {
        MassSpectra massSpectra = new MassSpectra();
        for (IPeakMSD iPeakMSD : peaks) {
            IPeakMassSpectrum massSpectrum = iPeakMSD.getExtractedMassSpectrum();
            massSpectra.addMassSpectrum((IScanMSD)massSpectrum);
        }
        return massSpectra;
    }

    private Map<String, String> setPeakIdentifier(List<? extends IPeakMSD> peaks) {
        HashMap<String, String> identifierTable = new HashMap<String, String>();
        int id = 1;
        for (IPeakMSD iPeakMSD : peaks) {
            IPeakMassSpectrum massSpectrum = iPeakMSD.getExtractedMassSpectrum();
            this.setIdentifier((IScanMSD)massSpectrum, id++, identifierTable);
        }
        return identifierTable;
    }

    private void resetPeakIdentifier(List<? extends IPeakMSD> peaks, Map<String, String> identifierTable) {
        for (IPeakMSD iPeakMSD : peaks) {
            IPeakMassSpectrum massSpectrum = iPeakMSD.getExtractedMassSpectrum();
            this.resetIdentifier((IScanMSD)massSpectrum, identifierTable);
        }
    }

    private void setIdentifier(IScanMSD massSpectrum, int id, Map<String, String> identifierTable) {
        String processIdentifier = PROCESS_ID + id;
        String identifier = massSpectrum.getIdentifier();
        identifierTable.put(processIdentifier, identifier);
        massSpectrum.setIdentifier(processIdentifier);
    }

    private void resetIdentifier(IScanMSD massSpectrum, Map<String, String> identifierTable) {
        String key = massSpectrum.getIdentifier();
        massSpectrum.setIdentifier(identifierTable.get(key));
    }

    private void setNumberOfTargetsToReport(IExtendedRuntimeSupport runtimeSupport, int numberOfTargets, IProgressMonitor monitor) {
        runtimeSupport.getNistSupport().setNumberOfTargets(numberOfTargets);
    }

    private void cleanFiles(IExtendedRuntimeSupport runtimeSupport, IProgressMonitor monitor) {
        monitor.subTask("Delete unecessary files.");
        INistSupport nistSupport = runtimeSupport.getNistSupport();
        this.deleteFile(nistSupport.getNistlogFile());
        this.deleteFile(nistSupport.getSrcreadyFile());
        this.deleteFile(nistSupport.getSrcresltFile());
        this.deleteFile(nistSupport.getAutoimpFile());
        this.deleteFile(nistSupport.getFilespecFile());
        this.deleteFile(nistSupport.getMassSpectraFile());
        String nistApplicationPath = runtimeSupport.getApplicationPath();
        File directory = new File(nistApplicationPath);
        HLMFilenameFilter hlmFileNameFilter = new HLMFilenameFilter();
        String[] stringArray = directory.list(hlmFileNameFilter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String hlmFile = stringArray[n2];
            this.deleteFile(String.valueOf(nistApplicationPath) + File.separator + hlmFile);
            logger.info((Object)("Delete: " + nistApplicationPath + File.separator + hlmFile));
            ++n2;
        }
    }

    private void deleteFile(String path) {
        File file = new File(path);
        logger.info((Object)("Delete: " + path));
        file.delete();
    }

    private void backupControlFiles(IExtendedRuntimeSupport runtimeSupport) {
        INistSupport nistSupport = runtimeSupport.getNistSupport();
        File autoimpFile = new File(nistSupport.getAutoimpFile());
        logger.info((Object)("autoimp.msd: " + autoimpFile.getAbsolutePath()));
        File autoimpFileBackup = new File(String.valueOf(nistSupport.getAutoimpFile()) + BACKUP_CONTROL_EXTENSION);
        if (autoimpFile.exists()) {
            boolean statusRename = autoimpFile.renameTo(autoimpFileBackup);
            logger.info((Object)("Status backup autoimp.msd: " + statusRename));
        }
        File filespecFile = new File(nistSupport.getFilespecFile());
        logger.info((Object)("filespec.fil: " + filespecFile.getAbsolutePath()));
        File filespecFileBackup = new File(String.valueOf(nistSupport.getFilespecFile()) + BACKUP_CONTROL_EXTENSION);
        if (filespecFile.exists()) {
            boolean statusRename = filespecFile.renameTo(filespecFileBackup);
            logger.info((Object)("Status backup filespec.fil: " + statusRename));
        }
    }

    private void restoreControlFiles(IExtendedRuntimeSupport runtimeSupport) {
        INistSupport nistSupport = runtimeSupport.getNistSupport();
        File autoimpFileBackup = new File(String.valueOf(nistSupport.getAutoimpFile()) + BACKUP_CONTROL_EXTENSION);
        File autoimpFile = new File(nistSupport.getAutoimpFile());
        if (autoimpFileBackup.exists()) {
            boolean statusRename = autoimpFileBackup.renameTo(autoimpFile);
            logger.info((Object)("Status restore autoimp.msd: " + statusRename));
        }
        File filespecFileBackup = new File(String.valueOf(nistSupport.getFilespecFile()) + BACKUP_CONTROL_EXTENSION);
        File filespecFile = new File(nistSupport.getFilespecFile());
        if (filespecFileBackup.exists()) {
            boolean statusRename = filespecFileBackup.renameTo(filespecFile);
            logger.info((Object)("Status restore filespec.fil: " + statusRename));
        }
    }

    private void prepareFiles(IExtendedRuntimeSupport runtimeSupport, IMassSpectra massSpectra, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException, NoConverterAvailableException {
        INistSupport nistSupport = runtimeSupport.getNistSupport();
        File file = new File(nistSupport.getMassSpectraFile());
        monitor.subTask("Write the peak mass spectra.");
        DatabaseConverter.convert((File)file, (IMassSpectra)massSpectra, (boolean)false, (String)MSL_CONVERTER_ID, (IProgressMonitor)monitor);
        PrintWriter pw = new PrintWriter(nistSupport.getAutoimpFile());
        pw.println(nistSupport.getFilespecFile());
        pw.flush();
        pw.close();
        pw = new PrintWriter(nistSupport.getFilespecFile());
        pw.println(String.valueOf(nistSupport.getMassSpectraFile()) + " OVERWRITE");
        pw.flush();
        pw.close();
    }

    private void prepareMSPFile(File file, IMassSpectra massSpectra, IProgressMonitor monitor) {
        monitor.subTask("Write the peak mass spectra to msp file.");
        DatabaseConverter.convert((File)file, (IMassSpectra)massSpectra, (boolean)false, (String)MSP_CONVERTER_ID, (IProgressMonitor)monitor);
    }

    private Compounds runNistApplication(IExtendedRuntimeSupport runtimeSupport, long maxProcessTime, IProgressMonitor monitor) throws IOException {
        monitor.subTask("Start the NIST-DB application.");
        runtimeSupport.executeRunCommand();
        try {
            monitor.subTask("Waiting for the result file ... this could take a while.");
            long start = System.currentTimeMillis();
            long max = start + maxProcessTime;
            this.waitForFile(new File(runtimeSupport.getNistSupport().getSrcreadyFile()), monitor, max);
            logger.info((Object)("Process time to get NIST results (ms): " + (System.currentTimeMillis() - start)));
            NistResultFileParser nistResultFileParser = new NistResultFileParser();
            File results = new File(runtimeSupport.getNistSupport().getSrcresltFile());
            this.waitForFile(results, monitor, max);
            Compounds compounds = nistResultFileParser.getCompounds(results);
            return compounds;
        }
        finally {
            runtimeSupport.executeKillCommand();
        }
    }

    private void waitForFile(File file, IProgressMonitor monitor, long max) throws IOException {
        try {
            long fs;
            while (!file.exists()) {
                Thread.sleep(100L);
                if (!monitor.isCanceled() && System.currentTimeMillis() <= max) continue;
                throw new OperationCanceledException();
            }
            do {
                fs = file.length();
                TimeUnit.SECONDS.sleep(1L);
                if (!monitor.isCanceled() && System.currentTimeMillis() <= max) continue;
                throw new OperationCanceledException();
            } while (fs != file.length());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationCanceledException("interrupted");
        }
    }

    private void openNistApplication(IExtendedRuntimeSupport runtimeSupport, IProgressMonitor monitor) {
        monitor.subTask("Start the NIST-DB application.");
        try {
            runtimeSupport.executeOpenCommand();
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    private IPeakIdentificationResults assignPeakCompounds(Compounds compounds, List<? extends IPeakMSD> peaks, IPeakIdentificationResults identificationResults, PeakIdentifierSettings peakIdentifierSettings, Map<String, String> identifierTable, IProcessingInfo<?> processingInfo, IProgressMonitor monitor) {
        monitor.subTask("Assign the identified peaks.");
        identificationResults = this.getPeakIdentificationResults(compounds, peaks, peakIdentifierSettings, identifierTable, processingInfo);
        return identificationResults;
    }

    public IPeakIdentificationResults getPeakIdentificationResults(Compounds compounds, List<? extends IPeakMSD> peaks, PeakIdentifierSettings peakIdentifierSettings, Map<String, String> identifierTable, IProcessingInfo<?> processingInfo) {
        PeakIdentificationResults identificationResults = new PeakIdentificationResults();
        float minMatchFactor = PreferenceSupplier.getMinMatchFactor();
        float minReverseMatchFactor = PreferenceSupplier.getMinReverseMatchFactor();
        int numberOfTargets = peakIdentifierSettings.getNumberOfTargets();
        for (Compound compound : compounds.getCompounds()) {
            String identifier = compound.getIdentfier();
            IPeakMSD peak = this.getPeakByIdentifier(peaks, identifier);
            if (peak != null) {
                ArrayList<IIdentificationTarget> peakTargets = new ArrayList<IIdentificationTarget>();
                int maxIndex = compound.size();
                PeakIdentificationResult identificationResult = new PeakIdentificationResult();
                int index = 1;
                while (index <= maxIndex) {
                    IIdentificationTarget identificationEntry = this.getPeakIdentificationEntry(compound, index);
                    IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
                    float matchFactor = comparisonResult.getMatchFactor();
                    float reverseMatchFactor = comparisonResult.getReverseMatchFactor();
                    if (matchFactor >= minMatchFactor && reverseMatchFactor >= minReverseMatchFactor) {
                        identificationEntry.setIdentifier(LIBRARY);
                        if (peakIdentifierSettings.getStoreTargets()) {
                            peakTargets.add(identificationEntry);
                        }
                        identificationResult.add(identificationEntry);
                    }
                    ++index;
                }
                Collections.sort(peakTargets, this.targetCombinedComparator);
                int size = numberOfTargets <= peakTargets.size() ? numberOfTargets : peakTargets.size();
                int i = 0;
                while (i < size) {
                    peak.getTargets().add((IIdentificationTarget)peakTargets.get(i));
                    ++i;
                }
                identificationResults.add((IIdentificationResult)identificationResult);
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The peak was identified successfully: " + peak.getModelDescription());
                processingInfo.addMessage((IProcessingMessage)processingMessage);
                continue;
            }
            processingInfo.addErrorMessage(DESCRIPTION, "The result id was not set, hence no result could be extracted.");
        }
        return identificationResults;
    }

    private IPeakMSD getPeakByIdentifier(List<? extends IPeakMSD> peaks, String identifier) {
        if (identifier.equals("")) {
            return null;
        }
        for (IPeakMSD iPeakMSD : peaks) {
            if (!iPeakMSD.getExtractedMassSpectrum().getIdentifier().equals(identifier)) continue;
            return iPeakMSD;
        }
        return null;
    }

    public IIdentificationTarget getPeakIdentificationEntry(Compound compound, int index) {
        Hit hit = compound.getHit(index);
        NISTIdentificationTarget identificationEntry = null;
        PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
        libraryInformation.setName(this.getName(hit.getName()));
        libraryInformation.setCasNumber(hit.getCAS());
        libraryInformation.setMiscellaneous(COMPOUND_IN_LIB_FACTOR + compound.getCompoundInLibraryFactor());
        libraryInformation.setContributor(LIBRARY);
        libraryInformation.setReferenceIdentifier(LIBRARY);
        libraryInformation.setRetentionIndex((float)hit.getRetentionIndex());
        PeakComparisonResult comparisonResult = new PeakComparisonResult(hit.getMatchFactor(), hit.getReverseMatchFactor(), 0.0f, 0.0f, hit.getProbability());
        try {
            identificationEntry = new NISTIdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
        return identificationEntry;
    }

    private String getName(String name) {
        name = name.replaceAll("\u00e0", ".alpha.");
        name = name.replaceAll("\u00e1", ".beta.");
        return name;
    }

    private IIdentificationResults assignMassSpectrumCompounds(List<Compound> compounds, List<IScanMSD> massSpectra, IIdentificationResults identificationResults, MassSpectrumIdentifierSettings massSpectrumIdentifierSettings, Map<String, String> identifier, IProgressMonitor monitor) {
        if (compounds.size() != massSpectra.size()) {
            return identificationResults;
        }
        monitor.subTask("Assign the identified mass spectra.");
        int index = 0;
        while (index < massSpectra.size()) {
            IScanMSD massSpectrum = massSpectra.get(index);
            Compound compound = compounds.get(index);
            IIdentificationResult identificationResult = this.getMassSpectrumIdentificationResult(massSpectrum, compound, massSpectrumIdentifierSettings);
            identificationResults.add(identificationResult);
            ++index;
        }
        return identificationResults;
    }

    public IIdentificationResult getMassSpectrumIdentificationResult(IScanMSD massSpectrum, Compound compound, MassSpectrumIdentifierSettings massSpectrumIdentifierSettings) {
        int numberOfTargets = massSpectrumIdentifierSettings.getNumberOfTargets();
        ArrayList<IIdentificationTarget> massSpectrumTargets = new ArrayList<IIdentificationTarget>();
        IdentificationResult identificationResult = new IdentificationResult();
        int index = 1;
        while (index <= compound.size()) {
            Hit hit = compound.getHit(index);
            IIdentificationTarget identificationEntry = this.getMassSpectrumIdentificationEntry(hit, compound);
            if (massSpectrumIdentifierSettings.getStoreTargets()) {
                massSpectrumTargets.add(identificationEntry);
            }
            identificationResult.add(identificationEntry);
            ++index;
        }
        Collections.sort(massSpectrumTargets, this.targetCombinedComparator);
        int size = numberOfTargets <= massSpectrumTargets.size() ? numberOfTargets : massSpectrumTargets.size();
        int i = 0;
        while (i < size) {
            massSpectrum.getTargets().add((IIdentificationTarget)massSpectrumTargets.get(i));
            ++i;
        }
        return identificationResult;
    }

    public IIdentificationTarget getMassSpectrumIdentificationEntry(Hit hit, Compound compound) {
        NISTIdentificationTarget identificationEntry = null;
        LibraryInformation libraryInformation = new LibraryInformation();
        libraryInformation.setName(this.getName(hit.getName()));
        libraryInformation.setCasNumber(hit.getCAS());
        libraryInformation.setMiscellaneous(COMPOUND_IN_LIB_FACTOR + compound.getCompoundInLibraryFactor());
        libraryInformation.setContributor(LIBRARY);
        libraryInformation.setReferenceIdentifier(LIBRARY);
        libraryInformation.setRetentionIndex((float)hit.getRetentionIndex());
        ComparisonResult comparisonResult = new ComparisonResult(hit.getMatchFactor(), hit.getReverseMatchFactor(), 0.0f, 0.0f, hit.getProbability());
        try {
            identificationEntry = new NISTIdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
        return identificationEntry;
    }
}

