/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.core;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.AbstractMassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.core.support.Identifier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.settings.MassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumIdentifier
extends AbstractMassSpectrumIdentifier {
    private static final String DESCRIPTION = "NIST-DB Identifier";

    public IProcessingInfo<IMassSpectra> identify(List<IScanMSD> massSpectrumList, IMassSpectrumIdentifierSettings identifierSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        MassSpectrumIdentifierSettings massSpectrumIdentifierSettings = identifierSettings instanceof MassSpectrumIdentifierSettings ? (MassSpectrumIdentifierSettings)identifierSettings : PreferenceSupplier.getMassSpectrumIdentifierSettings();
        try {
            Identifier identifier = new Identifier();
            IMassSpectra massSpectra = identifier.runMassSpectrumIdentification(massSpectrumList, massSpectrumIdentifierSettings, monitor);
            processingInfo.setProcessingResult((Object)massSpectra);
        }
        catch (FileNotFoundException e) {
            processingInfo.addErrorMessage(DESCRIPTION, "An I/O error ocurred.");
        }
        return processingInfo;
    }
}

