/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.model.IdentifierFile;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.editors.IdentifierFileListUtil;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.swt.IdentifierFileListUI;
import org.eclipse.chemclipse.converter.support.FileExtensionCompiler;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverterSupport;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class IdentifierTableEditor
extends FieldEditor {
    private Composite compositeButtons;
    private Button buttonAddFile;
    private Button buttonAddDirectory;
    private Button buttonRemove;
    private Button buttonRemoveAll;
    private String[] fileExtensions = new String[0];
    private String[] fileNames = new String[0];
    private IdentifierFileListUI identifierFileListUI;
    private IdentifierFileListUtil identifierFileListUtil = new IdentifierFileListUtil();

    public IdentifierTableEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
        this.initializeFileExtensions();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).getTable().setEnabled(enabled);
        this.buttonAddFile.setEnabled(enabled);
        this.buttonAddDirectory.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonRemoveAll.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.identifierFileListUI != null) {
            this.identifierFileListUI.getTable().setFocus();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected IdentifierFileListUI getListUI() {
        return this.identifierFileListUI;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.identifierFileListUI.getTable().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doLoad() {
        if (this.identifierFileListUI != null) {
            String storedContent = this.getPreferenceStore().getString(this.getPreferenceName());
            if (storedContent == null || "".equals(storedContent)) {
                this.identifierFileListUI.setInput(null);
            } else {
                this.identifierFileListUI.setInput(this.getDatabaseFiles(storedContent));
            }
        }
    }

    protected void doLoadDefault() {
        if (this.identifierFileListUI != null) {
            String storedContent = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            if (storedContent == null || "".equals(storedContent)) {
                this.identifierFileListUI.setInput(null);
            } else {
                this.identifierFileListUI.setInput(this.getDatabaseFiles(storedContent));
            }
        }
    }

    protected void doStore() {
        TableItem[] tableItems = this.identifierFileListUI.getTable().getItems();
        ArrayList<String> files = new ArrayList<String>();
        int i = 0;
        while (i < tableItems.length) {
            IdentifierFile calibrationFile;
            File file;
            Object object = tableItems[i].getData();
            if (object instanceof IdentifierFile && (file = (calibrationFile = (IdentifierFile)object).getFile()) != null && file.exists()) {
                files.add(file.getAbsolutePath());
            }
            ++i;
        }
        String[] items = files.toArray(new String[files.size()]);
        String storedContent = this.identifierFileListUtil.createList(items);
        if (storedContent != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), storedContent);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gridDataControl = new GridData();
        gridDataControl.horizontalSpan = numColumns;
        control.setLayoutData((Object)gridDataControl);
        this.identifierFileListUI = this.createDataSection(parent);
        this.compositeButtons = this.createButtonSection(parent);
    }

    private IdentifierFileListUI createDataSection(Composite parent) {
        IdentifierFileListUI identifierFileListUI = this.getTableControl(parent);
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        identifierFileListUI.getTable().setLayoutData((Object)gridData);
        return identifierFileListUI;
    }

    private Composite createButtonSection(Composite parent) {
        Composite composite = this.getButtonControl(parent);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void createButtons(Composite composite) {
        this.buttonAddFile = this.createButtonAddFile(composite, "Add DB (File)", "Add a new database.");
        this.buttonAddDirectory = this.createButtonAddDirectory(composite, "Add DB (Directory)", "Add a new database.");
        this.buttonRemove = this.createButtonRemove(composite, "Remove", "Remove the selected database(s).");
        this.buttonRemoveAll = this.createButtonRemoveAll(composite, "Remove All", "Remove all database(s).");
    }

    private Button createButtonAddFile(Composite parent, String text, String tooltip) {
        Button button = this.createButton(parent, text, tooltip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdentifierTableEditor.this.addFileDB(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonAddDirectory(Composite parent, String text, String tooltip) {
        Button button = this.createButton(parent, text, tooltip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdentifierTableEditor.this.addDirectoryDB(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent, String text, String tooltip) {
        Button button = this.createButton(parent, text, tooltip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdentifierTableEditor.this.remove();
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent, String text, String tooltip) {
        Button button = this.createButton(parent, text, tooltip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IdentifierTableEditor.this.removeAll();
            }
        });
        return button;
    }

    private Button createButton(Composite parent, String text, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setToolTipText(tooltip);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return button;
    }

    private void addFileDB(Shell shell) {
        this.setPresentsDefaultValue(false);
        IdentifierFile databaseFile = this.selectDatabaseFile(shell);
        if (databaseFile != null) {
            this.identifierFileListUI.add(databaseFile);
            this.selectionChanged();
        }
    }

    private void addDirectoryDB(Shell shell) {
        this.setPresentsDefaultValue(false);
        IdentifierFile databaseFile = this.selectDatabaseDirectory(shell);
        if (databaseFile != null) {
            this.identifierFileListUI.add(databaseFile);
            this.selectionChanged();
        }
    }

    private void remove() {
        this.setPresentsDefaultValue(false);
        Table table = this.identifierFileListUI.getTable();
        int[] indices = table.getSelectionIndices();
        int offset = 0;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if ((index -= offset) >= 0) {
                table.remove(index);
                ++offset;
            }
            ++n2;
        }
        this.selectionChanged();
    }

    private void removeAll() {
        this.setPresentsDefaultValue(false);
        this.identifierFileListUI.getTable().removeAll();
    }

    private void selectionChanged() {
        int index = this.identifierFileListUI.getTable().getSelectionIndex();
        this.buttonRemove.setEnabled(index >= 0);
        this.buttonRemoveAll.setEnabled(index >= 0);
    }

    private IdentifierFile selectDatabaseFile(Shell shell) {
        IdentifierFile identifierFile = null;
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setText("Select a Database");
        fileDialog.setFilterPath(PreferenceSupplier.getFilterPathIdentifierFiles());
        fileDialog.setFilterExtensions(this.fileExtensions);
        fileDialog.setFilterNames(this.fileNames);
        String filterPath = fileDialog.open();
        if (filterPath != null) {
            File file = new File(filterPath);
            PreferenceSupplier.setFilterPathIdentifierFiles((String)file.getParentFile().getAbsolutePath());
            identifierFile = this.addIdentifier(file);
        }
        return identifierFile;
    }

    private IdentifierFile selectDatabaseDirectory(Shell shell) {
        IdentifierFile identifierFile = null;
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
        directoryDialog.setText("Select a Database");
        directoryDialog.setFilterPath(PreferenceSupplier.getFilterPathIdentifierFiles());
        String filterPath = directoryDialog.open();
        if (filterPath != null) {
            File file = new File(filterPath);
            PreferenceSupplier.setFilterPathIdentifierFiles((String)file.getAbsolutePath());
            identifierFile = this.addIdentifier(file);
        }
        return identifierFile;
    }

    private IdentifierFile addIdentifier(File file) {
        TableItem[] tableItems;
        IdentifierFile identifierFile = new IdentifierFile(file);
        TableItem[] tableItemArray = tableItems = this.identifierFileListUI.getTable().getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object instanceof IdentifierFile && ((IdentifierFile)object).equals((Object)identifierFile)) {
                identifierFile = null;
                break;
            }
            ++n2;
        }
        return identifierFile;
    }

    private List<IdentifierFile> getDatabaseFiles(String storedContent) {
        String[] files = this.identifierFileListUtil.parseString(storedContent);
        ArrayList<IdentifierFile> identifierFiles = new ArrayList<IdentifierFile>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File database = new File(file);
            if (database.exists()) {
                identifierFiles.add(new IdentifierFile(database));
            }
            ++n2;
        }
        return identifierFiles;
    }

    private Composite getButtonControl(Composite parent) {
        if (this.compositeButtons == null) {
            this.compositeButtons = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.compositeButtons.setLayout((Layout)layout);
            this.createButtons(this.compositeButtons);
            this.compositeButtons.addDisposeListener(event -> {
                this.buttonAddFile = null;
                this.buttonRemove = null;
                this.buttonRemoveAll = null;
                this.compositeButtons = null;
            });
        } else {
            this.checkParent((Control)this.compositeButtons, parent);
        }
        this.selectionChanged();
        return this.compositeButtons;
    }

    private IdentifierFileListUI getTableControl(Composite parent) {
        if (this.identifierFileListUI == null) {
            this.identifierFileListUI = new IdentifierFileListUI(parent, 2818);
            Table table = this.identifierFileListUI.getTable();
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IdentifierTableEditor.this.selectionChanged();
                }
            });
        } else {
            this.checkParent((Control)this.identifierFileListUI.getTable(), parent);
        }
        return this.identifierFileListUI;
    }

    private void initializeFileExtensions() {
        DatabaseConverterSupport databaseConverterSupport = DatabaseConverter.getDatabaseConverterSupport();
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        extensions.add("*.*");
        names.add("All Files (*.*)");
        List suppliers = databaseConverterSupport.getSupplier();
        for (ISupplier supplier : suppliers) {
            String directory;
            if (!supplier.isImportable() || (directory = supplier.getDirectoryExtension()) != null && !"".equals(directory)) continue;
            FileExtensionCompiler fileExtensionCompiler = new FileExtensionCompiler(supplier.getFileExtension(), true);
            extensions.add(fileExtensionCompiler.getCompiledFileExtension());
            names.add(supplier.getFilterName());
        }
        this.fileExtensions = extensions.toArray(new String[extensions.size()]);
        this.fileNames = names.toArray(new String[names.size()]);
    }
}

