/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.ui.activator.AbstractActivatorUI;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class Activator
extends AbstractActivatorUI {
    private static final Logger logger = Logger.getLogger(Activator.class);
    private static Activator plugin;
    private List<EventHandler> registeredEventHandler = new ArrayList<EventHandler>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializePreferenceStore(PreferenceSupplier.INSTANCE());
        this.registerEventBroker(context);
    }

    public void stop(BundleContext context) throws Exception {
        IEventBroker eventBroker = this.getEventBroker(context);
        if (eventBroker != null) {
            for (EventHandler eventHandler : this.registeredEventHandler) {
                eventBroker.unsubscribe(eventHandler);
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static AbstractActivatorUI getDefault() {
        return plugin;
    }

    private void registerEventBroker(BundleContext bundleContext) {
        IEventBroker eventBroker = this.getEventBroker(bundleContext);
        if (eventBroker != null) {
            this.registeredEventHandler.add(this.registerEventHandler(eventBroker, "org.eclipse.e4.data", "library/msd/add/dbsearch"));
            this.registeredEventHandler.add(this.registerEventHandler(eventBroker, "org.eclipse.e4.data", "library/msd/remove/dbsearch"));
        }
    }

    private EventHandler registerEventHandler(IEventBroker eventBroker, final String property, final String topic) {
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    File file;
                    Object object = event.getProperty(property);
                    if (object instanceof File && (file = (File)object).exists()) {
                        String library = file.getAbsolutePath();
                        List libraries = PreferenceSupplier.getMassSpectraFiles();
                        if ("library/msd/add/dbsearch".equals(topic)) {
                            if (!libraries.contains(library)) {
                                libraries.add(library);
                            }
                        } else if ("library/msd/remove/dbsearch".equals(topic) && libraries.contains(library)) {
                            libraries.remove(library);
                        }
                        PreferenceSupplier.setMassSpectraFiles((List)libraries);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
        };
        eventBroker.subscribe(topic, eventHandler);
        return eventHandler;
    }

    private IEventBroker getEventBroker(BundleContext bundleContext) {
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        eclipseContext.set(Logger.class, null);
        return (IEventBroker)eclipseContext.get(IEventBroker.class);
    }
}

