/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.NoRetentionIndicesConverterAvailableException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.IRetentionIndicesExportConverter;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.IRetentionIndicesImportConverter;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.RetentionIndicesConverterSupport;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.RetentionIndicesSupplier;
import org.eclipse.chemclipse.chromatogram.alignment.model.core.IRetentionIndices;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class RetentionIndicesConverter {
    private static final Logger logger = Logger.getLogger(RetentionIndicesConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.alignment.converter.retentionIndexSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILE_EXTENSION = "fileExtension";
    private static final String IS_EXPORTABLE = "isExportable";
    private static final String IS_IMPORTABLE = "isImportable";
    private static final String EXPORT_CONVERTER = "exportConverter";
    private static final String IMPORT_CONVERTER = "importConverter";

    private RetentionIndicesConverter() {
    }

    public static IRetentionIndices convert(File retentionIndices, String converterId) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IRetentionIndices instance = null;
        IRetentionIndicesImportConverter importConverter = RetentionIndicesConverter.getRetentionIndicesImportConverter(converterId);
        if (importConverter != null) {
            instance = importConverter.convert(retentionIndices);
        }
        return instance;
    }

    public static IRetentionIndices convert(File retentionIndices) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException {
        Object chromatogramInstance = RetentionIndicesConverter.getRetentionIndices(retentionIndices);
        if (chromatogramInstance instanceof IRetentionIndices) {
            return (IRetentionIndices)chromatogramInstance;
        }
        return null;
    }

    private static Object getRetentionIndices(File chromatogram) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException {
        RetentionIndicesConverterSupport converterSupport = RetentionIndicesConverter.getRetentionIndicesConverterSupport();
        try {
            List<String> availableConverterIds = converterSupport.getAvailableConverterIds(chromatogram);
            for (String converterId : availableConverterIds) {
                IRetentionIndicesImportConverter importConverter = RetentionIndicesConverter.getRetentionIndicesImportConverter(converterId);
                if (importConverter == null) continue;
                try {
                    IRetentionIndices chromatogramInstance = importConverter.convert(chromatogram);
                    if (chromatogramInstance == null) continue;
                    return chromatogramInstance;
                }
                catch (IOException e) {
                    logger.info((Object)e);
                }
            }
        }
        catch (NoRetentionIndicesConverterAvailableException e) {
            logger.info((Object)e);
            return null;
        }
        return null;
    }

    public static File convert(File file, IRetentionIndices retentionIndices, String converterId) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        File chromFile = null;
        IRetentionIndicesExportConverter exportConverter = RetentionIndicesConverter.getRetentionIndicesExportConverter(converterId);
        if (exportConverter != null) {
            chromFile = exportConverter.convert(file, retentionIndices);
        }
        return chromFile;
    }

    private static IRetentionIndicesImportConverter getRetentionIndicesImportConverter(String converterId) {
        IConfigurationElement element = RetentionIndicesConverter.getConfigurationElement(converterId);
        IRetentionIndicesImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IRetentionIndicesImportConverter)element.createExecutableExtension(IMPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IRetentionIndicesExportConverter getRetentionIndicesExportConverter(String converterId) {
        IConfigurationElement element = RetentionIndicesConverter.getConfigurationElement(converterId);
        IRetentionIndicesExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IRetentionIndicesExportConverter)element.createExecutableExtension(EXPORT_CONVERTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static RetentionIndicesConverterSupport getRetentionIndicesConverterSupport() {
        IConfigurationElement[] extensions;
        RetentionIndicesConverterSupport chromatogramConverterSupport = new RetentionIndicesConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            RetentionIndicesSupplier supplier = new RetentionIndicesSupplier();
            supplier.setFileExtension(element.getAttribute(FILE_EXTENSION));
            if (RetentionIndicesConverter.isValid(supplier.getFileExtension())) {
                supplier.setId(element.getAttribute(ID));
                supplier.setDescription(element.getAttribute(DESCRIPTION));
                supplier.setFilterName(element.getAttribute(FILTER_NAME));
                supplier.setExportable(Boolean.valueOf(element.getAttribute(IS_EXPORTABLE)));
                supplier.setImportable(Boolean.valueOf(element.getAttribute(IS_IMPORTABLE)));
                chromatogramConverterSupport.add(supplier);
            }
            ++n2;
        }
        return chromatogramConverterSupport;
    }

    protected static boolean isValid(String input) {
        if (input == null) {
            return false;
        }
        String regex = "[\\\\/:*?\"<>|]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        return !matcher.find();
    }
}

