/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.converter.ui.wizards.ImportDirectoryWizardPage;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.RawFileSelectionWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ChromatogramImportWizard
extends Wizard
implements IImportWizard {
    private static final Logger logger = Logger.getLogger(ChromatogramImportWizard.class);
    private static final String DESCRIPTION = "Chromatogram MSD Import";
    private static final String CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse";
    private RawFileSelectionWizardPage rawFileSelectionWizardPage;
    private ImportDirectoryWizardPage importDirectoryWizardPage;

    public ChromatogramImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Chromatogram Import Wizard");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.rawFileSelectionWizardPage = new RawFileSelectionWizardPage(DataType.MSD, "Select the chromatograms to import.", null);
        this.addPage((IWizardPage)this.rawFileSelectionWizardPage);
        this.importDirectoryWizardPage = new ImportDirectoryWizardPage(DESCRIPTION, "Select the import folder", null);
        this.addPage((IWizardPage)this.importDirectoryWizardPage);
    }

    public boolean performFinish() {
        final List<File> inputFiles = this.getInputFiles();
        if (inputFiles.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select at least one chromatogram.");
            return false;
        }
        final String importDirectory = this.importDirectoryWizardPage.getSelectedDirectory();
        if (importDirectory == null || importDirectory.equals("")) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select an import directory.");
            return false;
        }
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                for (File inputFile : inputFiles) {
                    try {
                        IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(inputFile, monitor);
                        IChromatogramMSD chromatogram = (IChromatogramMSD)processingInfo.getProcessingResult();
                        String directory = importDirectory;
                        if (!importDirectory.endsWith(File.separator)) {
                            directory = String.valueOf(directory) + File.separator;
                        }
                        File outputFile = new File(String.valueOf(directory) + chromatogram.getName());
                        ChromatogramConverterMSD.getInstance().convert(outputFile, (IChromatogram)chromatogram, ChromatogramImportWizard.CONVERTER_ID, monitor);
                    }
                    catch (TypeCastException e) {
                        logger.warn((Object)e);
                    }
                }
            }
        };
        try {
            this.getContainer().run(true, false, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Something has gone wrong with the chromatogram import.");
            return false;
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Something has gone wrong with the chromatogram import.");
            return false;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)DESCRIPTION, (String)"All chromatograms have been imported successfully.");
        return true;
    }

    private List<File> getInputFiles() {
        ArrayList<File> inputFiles = new ArrayList<File>();
        IStructuredSelection selection = this.rawFileSelectionWizardPage.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof File) {
                    inputFiles.add((File)object);
                }
                ++n2;
            }
        }
        return inputFiles;
    }
}

