/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.model.reports;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.converter.model.reports.IReport;
import org.eclipse.chemclipse.converter.model.reports.IReportPeak;

public class Report<T extends IReportPeak>
implements IReport<T> {
    private int reportNumber;
    private String name;
    private double totalArea;
    private int numberOfExpectedPeaks;
    private List<T> reportPeaks = new ArrayList<T>();

    @Override
    public int getReportNumber() {
        return this.reportNumber;
    }

    @Override
    public void setReportNumber(int reportNumber) {
        this.reportNumber = reportNumber;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getTotalArea() {
        return this.totalArea;
    }

    @Override
    public void setTotalArea(double totalArea) {
        this.totalArea = totalArea;
    }

    @Override
    public double getCalculatedTotalArea() {
        double calculatedTotalArea = 0.0;
        for (IReportPeak reportPeak : this.reportPeaks) {
            calculatedTotalArea += reportPeak.getArea();
        }
        return calculatedTotalArea;
    }

    @Override
    public int getNumberOfExpectedPeaks() {
        return this.numberOfExpectedPeaks;
    }

    @Override
    public void setNumberOfExpectedPeaks(int numberOfExpectedPeaks) {
        this.numberOfExpectedPeaks = numberOfExpectedPeaks;
    }

    @Override
    public List<T> getReportPeaks() {
        return this.reportPeaks;
    }

    @Override
    public boolean isVerfied() {
        return this.totalArea == this.getCalculatedTotalArea();
    }
}

