/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.support.FileExtensionCompiler;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.converter.ISupplier;

public interface IConverterSupport {
    public static final Predicate<ISupplier> EXPORT_SUPPLIER = supplier -> supplier.isExportable();
    public static final Predicate<ISupplier> IMPORT_SUPPLIER = supplier -> supplier.isImportable();
    public static final Predicate<ISupplier> ALL_SUPPLIER = supplier -> true;

    default public String[] getFilterExtensions(Predicate<? super ISupplier> filter) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (ISupplier iSupplier : this.getSupplier(filter)) {
            if (iSupplier.getDirectoryExtension().equals("")) {
                FileExtensionCompiler fileExtensionCompiler = new FileExtensionCompiler(iSupplier.getFileExtension(), true);
                extensions.add(fileExtensionCompiler.getCompiledFileExtension());
                continue;
            }
            extensions.add("*.");
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    @Deprecated
    default public String[] getFilterExtensions() throws NoConverterAvailableException {
        String[] extensions = this.getFilterExtensions(ALL_SUPPLIER);
        if (extensions.length == 0) {
            throw new NoConverterAvailableException();
        }
        return extensions;
    }

    @Deprecated
    default public String[] getExportableFilterExtensions() throws NoConverterAvailableException {
        String[] extensions = this.getFilterExtensions(EXPORT_SUPPLIER);
        if (extensions.length == 0) {
            throw new NoConverterAvailableException();
        }
        return extensions;
    }

    default public String[] getFilterNames(Predicate<? super ISupplier> filter) {
        ArrayList<String> filterNames = new ArrayList<String>();
        for (ISupplier iSupplier : this.getSupplier(filter)) {
            filterNames.add(iSupplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Deprecated
    default public String[] getFilterNames() throws NoConverterAvailableException {
        return this.getFilterNames(ALL_SUPPLIER);
    }

    @Deprecated
    default public String[] getExportableFilterNames() throws NoConverterAvailableException {
        String[] names = this.getFilterNames(EXPORT_SUPPLIER);
        if (names.length == 0) {
            throw new NoConverterAvailableException();
        }
        return names;
    }

    @Deprecated
    default public String getConverterId(int index) throws NoConverterAvailableException {
        try {
            return this.getSupplier().get(index).getId();
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoConverterAvailableException();
        }
    }

    default public String getConverterId(final String name, final boolean exportConverterOnly) throws NoConverterAvailableException {
        Collection<? extends ISupplier> supplier = this.getSupplier((Predicate<? super ISupplier>)new Predicate<ISupplier>(){

            @Override
            public boolean test(ISupplier supplier) {
                return supplier.getFilterName().equals(name) && (!exportConverterOnly || supplier.isExportable());
            }
        });
        if (supplier.isEmpty()) {
            throw new NoConverterAvailableException();
        }
        return supplier.iterator().next().getId();
    }

    @Deprecated
    default public List<String> getAvailableConverterIds(File file) throws NoConverterAvailableException {
        List<ISupplier> suppliers = Converter.getSupplierForFile(file, this.getSupplier());
        if (suppliers.isEmpty()) {
            throw new NoConverterAvailableException();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ISupplier supplier : suppliers) {
            list.add(supplier.getId());
        }
        return list;
    }

    default public Collection<? extends ISupplier> getSupplier(Predicate<? super ISupplier> filter) {
        ArrayList<ISupplier> list = new ArrayList<ISupplier>();
        for (ISupplier supplier : this.getSupplier()) {
            if (!filter.test((ISupplier)supplier)) continue;
            list.add(supplier);
        }
        return list;
    }

    public List<ISupplier> getSupplier();

    default public ISupplier getSupplier(String id) throws NoConverterAvailableException {
        Collection<? extends ISupplier> collection = this.getSupplier((? super ISupplier supplier) -> supplier.getId().equals(id));
        if (collection.isEmpty()) {
            throw new NoConverterAvailableException();
        }
        return collection.iterator().next();
    }

    @Deprecated
    default public List<ISupplier> getExportSupplier() {
        return new ArrayList<ISupplier>(this.getSupplier(EXPORT_SUPPLIER));
    }

    public DataCategory getDataCategory();

    public String getName();

    default public String getID() {
        return "ConverterSupport:" + this.getClass().getName();
    }
}

