/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.chemclipse.converter.core.IExportConverter;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;

public abstract class AbstractExportConverter
implements IExportConverter {
    public IProcessingInfo<File> validate(File file) {
        if (file == null) {
            return this.getProcessingInfo("The file couldn't be found.");
        }
        IProcessingInfo<File> processingInfo = this.createDirectoriesAndFiles(file);
        if (!file.canWrite()) {
            return this.getProcessingInfo("The file is not writeable: " + file.getAbsolutePath());
        }
        return processingInfo;
    }

    private IProcessingInfo<File> createDirectoriesAndFiles(File file) {
        if (file.isDirectory()) {
            if (!file.exists() && !file.mkdirs()) {
                return this.getProcessingInfo("The given directory couldn't be created: " + file.getAbsolutePath());
            }
        } else {
            File newFile = new File(file.getParentFile().getAbsolutePath());
            if (!newFile.exists() && !newFile.mkdirs()) {
                return this.getProcessingInfo("The given directory couldn't be created: " + file.getAbsolutePath());
            }
            try {
                if (!file.exists() && !file.createNewFile()) {
                    return this.getProcessingInfo("The given file couldn't be created:" + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                return this.getProcessingInfo("The given file couldn't be created:" + file.getAbsolutePath());
            }
        }
        return new ProcessingInfo();
    }

    private IProcessingInfo<File> getProcessingInfo(String message) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Export Converter", message);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

