/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.chromatogram;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramSupplier;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramImportConverter;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractChromatogramConverter<P extends IPeak, T extends IChromatogram<P>>
implements IChromatogramConverter<P, T> {
    private static final Logger logger = Logger.getLogger(AbstractChromatogramConverter.class);
    private static final String DESCRIPTION_IMPORT = "Chromatogram Import Converter";
    private static final String DESCRIPTION_EXPORT = "Chromatogram Export Converter";
    private String extensionPoint = "";
    private final Class<T> type;
    private final DataCategory dataCategory;

    public AbstractChromatogramConverter(String extensionPoint, Class<T> type, DataCategory dataCategory) {
        this.extensionPoint = extensionPoint;
        this.type = type;
        this.dataCategory = dataCategory;
    }

    @Override
    public IChromatogramConverterSupport getChromatogramConverterSupport() {
        IConfigurationElement[] extensions;
        ChromatogramConverterSupport chromatogramConverterSupport = new ChromatogramConverterSupport(this.dataCategory);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(this.extensionPoint);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramSupplier supplier = new ChromatogramSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid(supplier.getFileExtension()) && Converter.isValid(supplier.getFileName()) && Converter.isValid(supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setImportable(this.isImportable(element));
                supplier.setExportable(this.isExportable(element));
                supplier.setMagicNumberMatcher(this.getMagicNumberMatcher(element));
                chromatogramConverterSupport.add(supplier);
            }
            ++n2;
        }
        return chromatogramConverterSupport;
    }

    @Override
    public IProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        return this.getChromatogram(file, true, monitor);
    }

    @Override
    public IProcessingInfo convertOverview(File file, String converterId, IProgressMonitor monitor) {
        Object converter = this.getChromatogramConverter(converterId, "importConverter");
        IProcessingInfo<IChromatogramOverview> processingInfo = converter instanceof IChromatogramImportConverter ? ((IChromatogramImportConverter)converter).convertOverview(file, monitor) : this.getNoOverviewImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    @Override
    public IProcessingInfo convert(File file, IProgressMonitor monitor) {
        return this.getChromatogram(file, false, monitor);
    }

    @Override
    public IProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        Object converter = this.getChromatogramConverter(converterId, "importConverter");
        IProcessingInfo processingInfo = converter instanceof IChromatogramImportConverter ? ((IChromatogramImportConverter)converter).convert(file, monitor) : this.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    @Override
    public IProcessingInfo getChromatogram(File file, boolean overview, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ArrayList processingMessagesError = new ArrayList();
        IChromatogramConverterSupport converterSupport = this.getChromatogramConverterSupport();
        try {
            List<String> availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                Object object;
                Object processingInfox;
                Object converter = this.getChromatogramConverter(converterId, "importConverter");
                if (!(converter instanceof IChromatogramImportConverter)) continue;
                IChromatogramImportConverter importConverter = (IChromatogramImportConverter)converter;
                if (overview) {
                    processingInfox = importConverter.convertOverview(file, monitor);
                    if (!processingInfox.hasErrorMessages()) {
                        object = processingInfox.getProcessingResult();
                        if (!(object instanceof IChromatogramOverview)) continue;
                        processingInfo.addMessages(processingInfox);
                        processingInfo.setProcessingResult(object);
                        break;
                    }
                    processingMessagesError.addAll(processingInfox.getMessages());
                    continue;
                }
                processingInfox = importConverter.convert(file, monitor);
                if (!processingInfox.hasErrorMessages()) {
                    object = processingInfox.getProcessingResult();
                    if (!this.type.isInstance(object)) continue;
                    processingInfo.addMessages(processingInfox);
                    processingInfo.setProcessingResult(object);
                    break;
                }
                processingMessagesError.addAll(processingInfox.getMessages());
            }
        }
        catch (NoConverterAvailableException e) {
            logger.info((Object)e);
            processingInfo.addErrorMessage(DESCRIPTION_IMPORT, "There is no suitable converter available to load the chromatogram file: " + this.getFileName(file));
        }
        if (this.type.isInstance(processingInfo.getProcessingResult())) {
            this.postProcessChromatogram(processingInfo, monitor);
        } else {
            for (IProcessingMessage processingMessage : processingMessagesError) {
                processingInfo.addMessage(processingMessage);
            }
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo convert(File file, T chromatogram, String converterId, IProgressMonitor monitor) {
        Object converter = this.getChromatogramConverter(converterId, "exportConverter");
        IProcessingInfo processingInfo = converter instanceof IChromatogramExportConverter ? ((IChromatogramExportConverter)converter).convert(file, (IChromatogram<? extends IPeak>)chromatogram, monitor) : this.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private boolean isImportable(IConfigurationElement element) {
        boolean result = false;
        if (element != null) {
            result = Boolean.valueOf(element.getAttribute("isImportable")) != false && this.getChromatogramConverter(element, "importConverter") instanceof IChromatogramImportConverter;
        }
        return result;
    }

    private boolean isExportable(IConfigurationElement element) {
        boolean result = false;
        if (element != null) {
            result = Boolean.valueOf(element.getAttribute("isExportable")) != false && this.getChromatogramConverter(element, "exportConverter") instanceof IChromatogramExportConverter;
        }
        return result;
    }

    private Object getChromatogramConverter(String converterId, String attribute) {
        IConfigurationElement element = this.getConfigurationElement(converterId);
        return this.getChromatogramConverter(element, attribute);
    }

    private Object getChromatogramConverter(IConfigurationElement element, String attribute) {
        Object instance = null;
        if (element != null) {
            try {
                instance = element.createExecutableExtension(attribute);
            }
            catch (CoreException e) {
                logger.warn((Object)("can't load ChromatogramConverter with id = " + element.getAttribute("id") + ", attribute = " + attribute + ": " + (Object)((Object)e)));
            }
        }
        return instance;
    }

    private IProcessingInfo getNoExportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage(DESCRIPTION_EXPORT, "There is no suitable converter available to save the chromatogram to the file: " + this.getFileName(file));
        return processingInfo;
    }

    private IProcessingInfo getNoImportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage(DESCRIPTION_IMPORT, "There is no suitable converter available to load the chromatogram from the file: " + this.getFileName(file));
        return processingInfo;
    }

    private IProcessingInfo getNoOverviewImportConverterAvailableProcessingInfo(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage(DESCRIPTION_IMPORT, "There is no suitable converter available to load the chromatogram overview from the file: " + this.getFileName(file));
        return processingInfo;
    }

    private String getFileName(File file) {
        return file != null ? file.getAbsolutePath() : "no file";
    }

    private IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(this.extensionPoint);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }
}

