/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.core;

import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.scanremover.settings.FilterSettingsCleaner;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FilterCleaner
extends AbstractChromatogramFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages()) {
            try {
                this.applyChromatogramCleanerFilter(chromatogramSelection, monitor);
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, "Chromatogram Cleaner", "Empty scans have been removed successfully."));
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Empty scans have been removed successfully."));
            }
            catch (FilterException e) {
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage()));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        FilterSettingsCleaner filterSettings = PreferenceSupplier.getCleanerFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }

    private void applyChromatogramCleanerFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) throws FilterException {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        ArrayList<Integer> scansToRemove = new ArrayList<Integer>();
        int scan = startScan;
        while (scan <= stopScan) {
            IScan chromatogramScan = chromatogram.getScan(scan);
            if (chromatogramScan instanceof IScanMSD) {
                if (((IScanMSD)chromatogramScan).getNumberOfIons() == 0) {
                    scansToRemove.add(scan);
                }
            } else if (chromatogramScan instanceof IScanCSD) {
                if (((IScanCSD)chromatogramScan).getTotalSignal() == 0.0f) {
                    scansToRemove.add(scan);
                }
            } else if (chromatogramScan instanceof IScanWSD && ((IScanWSD)chromatogramScan).getScanSignals().size() == 0) {
                scansToRemove.add(scan);
            }
            ++scan;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Remove empty scan(s) from chromatogram.", (int)100);
        try {
            int removeCounter = 0;
            for (Integer scan2 : scansToRemove) {
                scan2 = scan2 - removeCounter;
                chromatogram.removeScan(scan2.intValue());
                ++removeCounter;
            }
            subMonitor.worked(1);
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        chromatogram.recalculateScanNumbers();
        chromatogramSelection.reset();
    }
}

