/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant;

import java.io.File;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.wizard.samplequant.ISampleQuantWizardElements;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class PageReportDataSelection
extends AbstractExtendedWizardPage {
    private static final Logger logger = Logger.getLogger(PageReportDataSelection.class);
    private ISampleQuantWizardElements wizardElements;
    private Text textAreaPercentReport;
    private Text textQuantitationReport;
    private Text textAdditionalReportData;

    public PageReportDataSelection(ISampleQuantWizardElements wizardElements) {
        super(PageReportDataSelection.class.getName());
        this.setTitle("Report Files");
        this.setDescription("Please select the report files.");
        this.wizardElements = wizardElements;
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.wizardElements.getSelectedChromatograms().size() > 0) {
                File fileQuantitation;
                File fileAreaPercent;
                String chromatogram = (String)this.wizardElements.getSelectedChromatograms().get(0);
                this.wizardElements.getSampleQuantReport().setPathChromatogramEdited(chromatogram);
                File chromatogramFile = new File(chromatogram);
                if (this.textAreaPercentReport.getText().trim().equals("") && (fileAreaPercent = this.searchForFile(chromatogramFile, "rteres.txt")) != null) {
                    this.textAreaPercentReport.setText(fileAreaPercent.getAbsolutePath());
                }
                if (this.textQuantitationReport.getText().trim().equals("") && (fileQuantitation = this.searchForFile(chromatogramFile, "SumRpt.txt")) != null) {
                    this.textQuantitationReport.setText(fileQuantitation.getAbsolutePath());
                }
            }
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createAreaPercentField(composite);
        this.createQuantitationReportField(composite);
        this.createAdditionalReportDataField(composite);
        this.validate();
        this.setControl((Control)composite);
    }

    private void createAreaPercentField(Composite composite) {
        this.textAreaPercentReport = new Text(composite, 2048);
        this.textAreaPercentReport.setText("");
        this.textAreaPercentReport.setLayoutData((Object)this.getGridDataText());
        this.textAreaPercentReport.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageReportDataSelection.this.validate();
            }
        });
        Button buttonSelect = new Button(composite, 8);
        buttonSelect.setText("rteres.txt");
        buttonSelect.setLayoutData((Object)this.getGridDataButton());
        buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog fileDialog = new FileDialog(shell, 8);
                fileDialog.setText("Select the peaks area percent report.");
                fileDialog.setFilterExtensions(new String[]{"*.txt"});
                fileDialog.setFilterNames(new String[]{"rteres.txt"});
                fileDialog.setFilterPath(PreferenceSupplier.INSTANCE().getPreferences().get("samplequantFilterPathRteres", ""));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    try {
                        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
                        preferences.put("samplequantFilterPathRteres", fileDialog.getFilterPath());
                        preferences.flush();
                    }
                    catch (BackingStoreException e1) {
                        logger.warn((Object)e1);
                    }
                    PageReportDataSelection.this.textAreaPercentReport.setText(pathname);
                }
            }
        });
    }

    private void createQuantitationReportField(Composite composite) {
        this.textQuantitationReport = new Text(composite, 2048);
        this.textQuantitationReport.setText("");
        this.textQuantitationReport.setLayoutData((Object)this.getGridDataText());
        this.textQuantitationReport.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageReportDataSelection.this.validate();
            }
        });
        Button buttonSelect = new Button(composite, 8);
        buttonSelect.setText("SumRpt.txt");
        buttonSelect.setLayoutData((Object)this.getGridDataButton());
        buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog fileDialog = new FileDialog(shell, 8);
                fileDialog.setText("Selec the quantitation report.");
                fileDialog.setFilterExtensions(new String[]{"*.txt"});
                fileDialog.setFilterNames(new String[]{"SumRpt.txt"});
                fileDialog.setFilterPath(PreferenceSupplier.INSTANCE().getPreferences().get("samplequantFilterPathSumRpt", ""));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    try {
                        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
                        preferences.put("samplequantFilterPathSumRpt", fileDialog.getFilterPath());
                        preferences.flush();
                    }
                    catch (BackingStoreException e1) {
                        logger.warn((Object)e1);
                    }
                    PageReportDataSelection.this.textQuantitationReport.setText(pathname);
                }
            }
        });
    }

    private void createAdditionalReportDataField(Composite composite) {
        this.textAdditionalReportData = new Text(composite, 2048);
        this.textAdditionalReportData.setText(PreferenceSupplier.INSTANCE().getPreferences().get("samplequantFilterPathTargets", ""));
        this.textAdditionalReportData.setLayoutData((Object)this.getGridDataText());
        this.textAdditionalReportData.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageReportDataSelection.this.validate();
            }
        });
        Button buttonSelect = new Button(composite, 8);
        buttonSelect.setText("targets.txt");
        buttonSelect.setLayoutData((Object)this.getGridDataButton());
        buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog fileDialog = new FileDialog(shell, 8);
                fileDialog.setText("Selec the additional report data.");
                fileDialog.setFilterExtensions(new String[]{"*.txt"});
                fileDialog.setFilterNames(new String[]{"targets.txt"});
                fileDialog.setFilterPath(PreferenceSupplier.INSTANCE().getPreferences().get("samplequantFilterPathTargets", ""));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    try {
                        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
                        String filterPathTargets = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
                        preferences.put("samplequantFilterPathTargets", filterPathTargets);
                        preferences.flush();
                    }
                    catch (BackingStoreException e1) {
                        logger.warn((Object)e1);
                    }
                    PageReportDataSelection.this.textAdditionalReportData.setText(pathname);
                }
            }
        });
    }

    protected GridData getGridDataText() {
        GridData gridData = new GridData(768);
        gridData.verticalIndent = 5;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }

    protected GridData getGridDataButton() {
        GridData gridData = new GridData();
        gridData.verticalIndent = 5;
        gridData.widthHint = 130;
        return gridData;
    }

    private File searchForFile(File file, String name) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                File fileFound = this.searchForFile(dirFile, name);
                if (fileFound != null) {
                    return fileFound;
                }
                ++n2;
            }
        } else if (file.getName().equals(name)) {
            return file;
        }
        return null;
    }

    private void validate() {
        File file;
        File file2;
        String message = null;
        String additionalReportData = this.textAdditionalReportData.getText().trim();
        if (!additionalReportData.equals("") && (file2 = new File(additionalReportData)).exists()) {
            this.wizardElements.setAdditionalReportData(additionalReportData);
        }
        if (this.wizardElements.getSelectedChromatograms().size() == 0) {
            message = "Please select a chromatogram.";
        }
        if (message == null) {
            String areaPercentReport = this.textAreaPercentReport.getText().trim();
            if (areaPercentReport.equals("")) {
                message = "Please select a valid area percent report.";
            } else {
                file = new File(areaPercentReport);
                if (file.exists()) {
                    this.wizardElements.setAreaPercentReport(areaPercentReport);
                } else {
                    message = "The selected area percent report doesn't exist.";
                }
            }
        }
        if (message == null) {
            String quantitationReport = this.textQuantitationReport.getText().trim();
            if (quantitationReport.equals("")) {
                message = "Please select a valid quantitation report.";
            } else {
                file = new File(quantitationReport);
                if (file.exists()) {
                    this.wizardElements.setQuantitationReport(quantitationReport);
                } else {
                    message = "The selected quantitation report doesn't exist.";
                }
            }
        }
        this.updateStatus(message);
    }
}

