/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.editors;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.editors.EditorSampleQuant;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.runnables.ImportChromatogramRunnable;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.swt.SampleQuantTableViewerUI;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class PageSampleQuant {
    private static final Logger logger = Logger.getLogger(PageSampleQuant.class);
    private EditorSampleQuant editorSampleQuant;
    private Label labelName;
    private Label labelDataName;
    private Label labelDate;
    private Label labelOperator;
    private Label labelMiscInfo;
    private Composite control;
    private Text textSearch;
    private SampleQuantTableViewerUI sampleQuantTableViewerUI;
    private ISampleQuantReport sampleQuantReport;
    private IChromatogramMSD chromatogramMSD;

    public PageSampleQuant(Composite container, EditorSampleQuant editorSampleQuant) {
        this.createControl(container);
        this.editorSampleQuant = editorSampleQuant;
    }

    public Composite getControl() {
        return this.control;
    }

    public void showData(ISampleQuantReport sampleQuantReport) {
        this.sampleQuantReport = sampleQuantReport;
        if (sampleQuantReport != null) {
            this.setTableInput();
            this.labelName.setText("Name: " + sampleQuantReport.getName());
            this.labelDataName.setText("Date Name: " + sampleQuantReport.getDataName());
            this.labelDate.setText("Date: " + sampleQuantReport.getDate());
            this.labelOperator.setText("Operator: " + sampleQuantReport.getOperator());
            this.labelMiscInfo.setText("Misc Info: " + sampleQuantReport.getMiscInfo());
            ImportChromatogramRunnable runnable = new ImportChromatogramRunnable(sampleQuantReport.getPathChromatogramEdited());
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            try {
                monitor.run(true, false, (IRunnableWithProgress)runnable);
                this.chromatogramMSD = runnable.getChromatogram();
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
        }
    }

    private void createControl(Composite container) {
        this.control = new Composite(container, 0);
        this.control.setBackground(Display.getCurrent().getSystemColor(1));
        this.control.setLayout((Layout)new GridLayout(2, false));
        this.createInfoField(this.control);
        this.createSearchField(this.control);
        this.createTableAndButtonsField(this.control);
    }

    private void createInfoField(Composite parent) {
        GridData gridDataLabel = new GridData(768);
        gridDataLabel.horizontalSpan = 2;
        this.labelName = new Label(parent, 0);
        this.labelName.setText("");
        this.labelName.setLayoutData((Object)gridDataLabel);
        this.labelDataName = new Label(parent, 0);
        this.labelDataName.setText("");
        this.labelDataName.setLayoutData((Object)gridDataLabel);
        this.labelDate = new Label(parent, 0);
        this.labelDate.setText("");
        this.labelDate.setLayoutData((Object)gridDataLabel);
        this.labelOperator = new Label(parent, 0);
        this.labelOperator.setText("");
        this.labelOperator.setLayoutData((Object)gridDataLabel);
        this.labelMiscInfo = new Label(parent, 0);
        this.labelMiscInfo.setText("");
        this.labelMiscInfo.setLayoutData((Object)gridDataLabel);
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)gridDataLabel);
    }

    private void createSearchField(Composite parent) {
        this.textSearch = new Text(parent, 2048);
        this.textSearch.setText("Search...");
        this.textSearch.setLayoutData((Object)new GridData(768));
        this.textSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PageSampleQuant.this.search();
            }
        });
        final IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        final Button buttonCaseSensitive = new Button(parent, 32);
        buttonCaseSensitive.setText("Case sensitive");
        buttonCaseSensitive.setSelection(preferences.getBoolean("samplequantSearchCaseSensitive", false));
        buttonCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    preferences.put("samplequantSearchCaseSensitive", Boolean.toString(buttonCaseSensitive.getSelection()));
                    preferences.flush();
                }
                catch (BackingStoreException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
    }

    private void createTableAndButtonsField(Composite parent) {
        Composite compositeMain = new Composite(parent, 0);
        GridData gridDataMain = new GridData(1808);
        gridDataMain.horizontalSpan = 2;
        compositeMain.setLayoutData((Object)gridDataMain);
        compositeMain.setLayout((Layout)new GridLayout(2, false));
        this.sampleQuantTableViewerUI = new SampleQuantTableViewerUI(compositeMain, 2048);
        GridData gridDataTable = new GridData(1808);
        this.sampleQuantTableViewerUI.getTable().setLayoutData((Object)gridDataTable);
        this.sampleQuantTableViewerUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = PageSampleQuant.this.sampleQuantTableViewerUI.getStructuredSelection().getFirstElement();
                if (object instanceof ISampleQuantSubstance) {
                    IScan scan;
                    ISampleQuantSubstance sampleQuantSubstance = (ISampleQuantSubstance)object;
                    int maxScan = sampleQuantSubstance.getMaxScan();
                    if (PageSampleQuant.this.chromatogramMSD != null && (scan = PageSampleQuant.this.chromatogramMSD.getScan(maxScan)) instanceof IScanMSD) {
                        PageSampleQuant.this.editorSampleQuant.setDirty(true);
                        IScanMSD scanMSD = (IScanMSD)scan;
                        if (scanMSD != null) {
                            IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                            eventBroker.send("scan/xxd/update/selection", (Object)scanMSD);
                        }
                    }
                }
            }
        });
        Composite compositeButtons = new Composite(compositeMain, 0);
        compositeButtons.setLayout((Layout)new GridLayout(1, true));
        compositeButtons.setLayoutData((Object)new GridData(1040));
        GridData gridDataButtons = new GridData(768);
        gridDataButtons.minimumWidth = 150;
        final Text textMinMatchQuality = new Text(compositeButtons, 2048);
        textMinMatchQuality.setText(Double.toString(PreferenceSupplier.INSTANCE().getPreferences().getDouble("samplequantMinMatchQuality", 95.0)));
        textMinMatchQuality.setLayoutData((Object)new GridData(768));
        Button button1 = new Button(compositeButtons, 8);
        button1.setText("Set Min MQ");
        button1.setLayoutData((Object)gridDataButtons);
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageBox messageBox = new MessageBox(shell, 456);
                messageBox.setText("Set Min Match Quality");
                messageBox.setMessage("Would you like to set the min match quality? Manual verifications will be overwritten.");
                if (64 == messageBox.open() && PageSampleQuant.this.sampleQuantReport != null) {
                    try {
                        double minMatchQuality = Double.parseDouble(textMinMatchQuality.getText().trim());
                        PageSampleQuant.this.sampleQuantReport.setMinMatchQuality(minMatchQuality);
                        PageSampleQuant.this.setTableInput();
                        PageSampleQuant.this.editorSampleQuant.setDirty(true);
                    }
                    catch (NumberFormatException e1) {
                        logger.warn((Object)e1);
                    }
                }
            }
        });
        Button button2 = new Button(compositeButtons, 8);
        button2.setText("Export targets.txt");
        button2.setLayoutData((Object)gridDataButtons);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog fileDialog = new FileDialog(shell, 8192);
                fileDialog.setText("Export targets.txt");
                fileDialog.setFilterExtensions(new String[]{"*.txt"});
                fileDialog.setFilterNames(new String[]{"Targets *.txt"});
                fileDialog.setFileName("targets.txt");
                String targetsFile = fileDialog.open();
                if (targetsFile != null) {
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileWriter(new File(targetsFile)));
                        printWriter.println("#NAME\tCAS");
                        if (PageSampleQuant.this.sampleQuantReport != null) {
                            for (ISampleQuantSubstance sampleQuantSubstance : PageSampleQuant.this.sampleQuantReport.getSampleQuantSubstances()) {
                                printWriter.print(sampleQuantSubstance.getName());
                                printWriter.print("\t");
                                printWriter.println(sampleQuantSubstance.getCasNumber().equals("") ? "Please add CAS#." : sampleQuantSubstance.getCasNumber());
                            }
                        }
                        printWriter.flush();
                        printWriter.close();
                        MessageBox messageBox = new MessageBox(shell, 2);
                        messageBox.setText("Export targets.txt");
                        messageBox.setMessage("Export of targets.txt file finished successfully.");
                        messageBox.open();
                    }
                    catch (Exception e1) {
                        MessageBox messageBox = new MessageBox(shell, 8);
                        messageBox.setText("Export targets.txt");
                        messageBox.setMessage("Something has gone wrong whilst exporting the targets.txt file.");
                        messageBox.open();
                    }
                }
            }
        });
    }

    private void search() {
        if (this.sampleQuantReport != null) {
            String searchTerms = this.textSearch.getText().trim();
            this.sampleQuantTableViewerUI.setInput(this.sampleQuantReport.getSampleQuantSubstances(searchTerms));
        }
    }

    private void setTableInput() {
        if (this.sampleQuantReport != null && this.sampleQuantTableViewerUI != null) {
            this.sampleQuantTableViewerUI.setInput(this.sampleQuantReport.getSampleQuantSubstances());
        }
    }
}

