/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.core.PeakDetectorMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class DetectorRunnable
implements IRunnableWithProgress {
    private IChromatogramSelectionMSD chromatogramSelection;
    private int detectedPeaks;
    private static final String PEAK_DETECTOR_ID = "org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis";

    public DetectorRunnable(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public int getDetectedPeaks() {
        return this.detectedPeaks;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Deconvolution (AMDIS)", -1);
            PeakDetectorMSD.detect((IChromatogramSelectionMSD)this.chromatogramSelection, (String)PEAK_DETECTOR_ID, (IProgressMonitor)monitor);
            this.detectedPeaks = this.chromatogramSelection.getChromatogramMSD().getNumberOfPeaks();
            this.updateSelection();
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DetectorRunnable.this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                    ((ChromatogramSelectionMSD)DetectorRunnable.this.chromatogramSelection).update(true);
                }
            }
        });
    }
}

