/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.MassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.core.runtime.IProgressMonitor;

public class LowPassMassSpectrumFilter
extends AbstractMassSpectrumFilter {
    private static final String DESCRIPTION = "Low Pass Mass Spectrum Filter";

    public IProcessingInfo<IMassSpectrumFilterResult> applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings filterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo;
        if (filterSettings == null) {
            filterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        }
        if (!(processingInfo = this.validate(massSpectra, (IMassSpectrumFilterSettings)filterSettings)).hasErrorMessages()) {
            if (filterSettings instanceof MassSpectrumFilterSettings) {
                MassSpectrumFilterSettings massSpectrumFilterSettings = (MassSpectrumFilterSettings)((Object)filterSettings);
                int numberLowest = massSpectrumFilterSettings.getNumberLowest();
                for (IScanMSD massSpectrum : massSpectra) {
                    ArrayList ions = new ArrayList(massSpectrum.getIons());
                    Collections.sort(ions, new IonAbundanceComparator(SortOrder.ASC));
                    ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
                    int counter = 0;
                    for (IIon ion : ions) {
                        if (counter >= numberLowest) {
                            ionsToRemove.add(ion);
                        }
                        ++counter;
                    }
                    for (IIon ion : ionsToRemove) {
                        massSpectrum.removeIon(ion);
                    }
                }
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
                MassSpectrumFilterResult massSpectrumFilterResult = new MassSpectrumFilterResult(ResultStatus.OK, "The low pass filter has been applied successfully.");
                processingInfo.setProcessingResult((Object)massSpectrumFilterResult);
            } else {
                processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + MassSpectrumFilterSettings.class);
            }
        }
        return processingInfo;
    }
}

