/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.NoiseCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.model.baseline.BaselineModel;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.AbstractChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.results.ChromatogramSegmentation;
import org.eclipse.chemclipse.model.results.NoiseSegmentMeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;

public abstract class AbstractChromatogramWSD
extends AbstractChromatogram<IChromatogramPeakWSD>
implements IChromatogramWSD {
    private static final long serialVersionUID = -7048942996283330150L;
    private INoiseCalculator noiseCalculator;
    private final Map<Double, IBaselineModel> baselineModels = new HashMap<Double, IBaselineModel>();

    public AbstractChromatogramWSD() {
        this.updateNoiseCalculator();
    }

    private void updateNoiseCalculator() {
        NoiseSegmentMeasurementResult noiseResult = this.getMeasurementResult(NoiseSegmentMeasurementResult.class);
        String noiseCalculatorId = noiseResult != null ? noiseResult.getNoiseCalculatorId() : PreferenceSupplier.getSelectedNoiseCalculatorId();
        this.noiseCalculator = NoiseCalculator.getNoiseCalculator((String)noiseCalculatorId);
    }

    @Override
    public Set<Double> getWavelengths() {
        HashSet<Double> wavelengths = new HashSet<Double>();
        int i = 1;
        while (i < this.getNumberOfScans()) {
            this.getSupplierScan(i).getScanSignals().forEach(signal -> {
                boolean bl = wavelengths.add(signal.getWavelength());
            });
            ++i;
        }
        return wavelengths;
    }

    public void recalculateTheNoiseFactor() {
        this.updateNoiseCalculator();
    }

    public float getSignalToNoiseRatio(float abundance) {
        if (this.noiseCalculator != null) {
            return this.noiseCalculator.getSignalToNoiseRatio((IChromatogram)this, abundance);
        }
        return 0.0f;
    }

    @Override
    public IScanWSD getSupplierScan(int scan) {
        IScan storedScan;
        int position = scan;
        if (position > 0 && position <= this.getScans().size() && (storedScan = (IScan)this.getScans().get(--position)) instanceof IScanWSD) {
            return (IScanWSD)storedScan;
        }
        return null;
    }

    public void fireUpdate(IChromatogramSelection chromatogramSelection) {
        if (chromatogramSelection instanceof ChromatogramSelectionWSD) {
            ((ChromatogramSelectionWSD)chromatogramSelection).update(true);
        }
    }

    public double getPeakIntegratedArea() {
        double integratedArea = 0.0;
        for (IChromatogramPeakWSD peak : this.getPeaks()) {
            integratedArea += peak.getIntegratedArea();
        }
        return integratedArea;
    }

    @Override
    public IBaselineModel getBaselineModel(double wavelength) {
        this.baselineModels.putIfAbsent(wavelength, (IBaselineModel)new BaselineModel((IChromatogram)this, Float.NaN));
        return this.baselineModels.get(wavelength);
    }

    @Override
    public void removeBaselineModel(double wavelength) {
        this.baselineModels.remove(wavelength);
    }

    @Override
    public Map<Double, IBaselineModel> getBaselineModels() {
        return Collections.unmodifiableMap(this.baselineModels);
    }

    @Override
    public boolean containsBaseline(double wavelength) {
        return this.baselineModels.containsValue(wavelength);
    }

    public <ResultType extends IMeasurementResult<?>> ResultType getMeasurementResult(Class<ResultType> type) {
        IMeasurementResult result = super.getMeasurementResult(type);
        if (result == null && type == ChromatogramSegmentation.class) {
            return (ResultType)((IMeasurementResult)type.cast(new ChromatogramSegmentation((IChromatogram)this, PreferenceSupplier.getDefaultSegmentWidth())));
        }
        return (ResultType)result;
    }

    public void addMeasurementResult(IMeasurementResult<?> chromatogramResult) {
        super.addMeasurementResult(chromatogramResult);
        if (chromatogramResult instanceof NoiseSegmentMeasurementResult) {
            this.recalculateTheNoiseFactor();
        }
    }
}

