/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;

public class WavelengthValueComparator
implements Comparator<IScanSignalWSD>,
Serializable {
    private static final long serialVersionUID = 8463067630896954737L;
    private SortOrder sortOrder;

    public WavelengthValueComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public WavelengthValueComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IScanSignalWSD scanSignal1, IScanSignalWSD scanSignal2) {
        int returnValue;
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Double.compare(scanSignal1.getWavelength(), scanSignal2.getWavelength());
                break;
            }
            case DESC: {
                returnValue = Double.compare(scanSignal2.getWavelength(), scanSignal1.getWavelength());
                break;
            }
            default: {
                returnValue = Double.compare(scanSignal1.getWavelength(), scanSignal2.getWavelength());
            }
        }
        return returnValue;
    }
}

