/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.invert.core;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.invert.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.invert.settings.FilterSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages()) {
            this.applyFilter(chromatogramSelection);
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram selection was successfully set to zero"));
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        FilterSettings filterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }

    private void applyFilter(IChromatogramSelection chromatogramSelection) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        float maxSignal = chromatogram.getMaxSignal();
        for (IScan scan : chromatogram.getScans()) {
            float adjustedIntensity = maxSignal - scan.getTotalSignal();
            scan.adjustTotalSignal(adjustedIntensity);
        }
    }
}

