/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xir.model.core;

import org.eclipse.chemclipse.model.core.AbstractSignal;
import org.eclipse.chemclipse.xir.model.core.ISignalXIR;

public class SignalXIR
extends AbstractSignal
implements ISignalXIR,
Comparable<ISignalXIR> {
    private static final long serialVersionUID = -2575735757102126907L;
    private double wavelength = 0.0;
    private double intensity = 0.0;

    public SignalXIR() {
    }

    public SignalXIR(double wavelength, double intensity) {
        this.wavelength = wavelength;
        this.intensity = intensity;
    }

    public double getX() {
        return this.wavelength;
    }

    public double getY() {
        return this.intensity;
    }

    @Override
    public double getWavelength() {
        return this.wavelength;
    }

    @Override
    public void setWavelength(double wavelength) {
        if (wavelength >= 0.0) {
            this.wavelength = wavelength;
        }
    }

    @Override
    public double getIntensity() {
        return this.intensity;
    }

    @Override
    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.wavelength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignalXIR other = (SignalXIR)obj;
        return Double.doubleToLongBits(this.wavelength) == Double.doubleToLongBits(other.wavelength);
    }

    public String toString() {
        return "SignalXIR [wavelength=" + this.wavelength + ", intensity=" + this.intensity + "]";
    }

    @Override
    public int compareTo(ISignalXIR signalXIR) {
        if (signalXIR != null) {
            return Double.compare(this.wavelength, signalXIR.getWavelength());
        }
        return 0;
    }
}

