/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pcr.model.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Position
implements Comparable<Position> {
    private int id = 0;
    private String row = "";
    private int column = 0;
    private Pattern pattern = Pattern.compile("([a-zA-Z]*)(\\d*)");

    public Position() {
        this("", 0);
    }

    public Position(String row, int column) {
        this.row = row;
        this.column = column;
    }

    public void setRowAndColumn(String positionAsString) {
        Matcher matcher;
        if (positionAsString != null && (matcher = this.pattern.matcher(positionAsString)).matches()) {
            this.row = matcher.group(1).trim();
            this.column = Integer.parseInt(matcher.group(2).trim());
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRow() {
        return this.row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.row == null ? 0 : this.row.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.column != other.column) {
            return false;
        }
        return !(this.row == null ? other.row != null : !this.row.equals(other.row));
    }

    public String toString() {
        return "Position [row=" + this.row + ", column=" + this.column + "]";
    }

    @Override
    public int compareTo(Position position) {
        int result = 0;
        if (position != null && (result = this.row.compareTo(position.getRow())) == 0) {
            result = Integer.compare(this.column, position.getColumn());
        }
        return result;
    }
}

