/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pcr.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.pcr.model.core.IChannel;

public class Channel
implements IChannel {
    private int id = -1;
    private String name = "";
    private int time = 0;
    private double temperature = 0.0;
    private boolean valid = false;
    private List<Double> points = new ArrayList<Double>();
    private IPoint crossingPoint = null;
    private String detectionName = "";

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        this.time = time;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public List<Double> getPoints() {
        return this.points;
    }

    @Override
    public void setPoints(List<Double> points) {
        this.points = points;
    }

    @Override
    public IPoint getCrossingPoint() {
        return this.crossingPoint;
    }

    @Override
    public void setCrossingPoint(IPoint crossingPoint) {
        this.crossingPoint = crossingPoint;
    }

    @Override
    public void setCrossingPoint(double crossingPointX) {
        int floor = (int)Math.floor(crossingPointX);
        int ceil = (int)Math.ceil(crossingPointX);
        if (floor >= 0 && floor < this.points.size() && ceil >= 0 && ceil < this.points.size()) {
            if (floor == ceil) {
                double y = this.points.get(floor);
                this.crossingPoint = new Point(crossingPointX, y);
            } else {
                Point p1 = new Point((double)floor, this.points.get(floor).doubleValue());
                Point p2 = new Point((double)ceil, this.points.get(ceil).doubleValue());
                LinearEquation equation = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
                double y = equation.calculateY(crossingPointX);
                this.crossingPoint = new Point(crossingPointX, y);
            }
        }
    }

    @Override
    public String getDetectionName() {
        return this.detectionName;
    }

    @Override
    public void setDetectionName(String detectionName) {
        this.detectionName = detectionName;
    }
}

