/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.profiles;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.settings.ApplicationSettings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class Profiles {
    private static final Logger logger = Logger.getLogger(Profiles.class);
    private static final String PACKAGE = "org.eclipse.chemclipse.rcp.app";
    private static final String PROFILES = "profiles";

    private Profiles() {
    }

    public static File[] getAvailableProfiles() {
        File directory = new File(Profiles.getProfileDirectory());
        if (!directory.exists() && !directory.mkdirs()) {
            logger.warn((Object)("The temporarily identifier directory could not be created: " + directory.getAbsolutePath()));
        }
        return directory.listFiles();
    }

    public static void createProfile(String name, boolean override) throws FileNotFoundException, CoreException {
        File file = new File(String.valueOf(Profiles.getProfileDirectory()) + File.separator + name);
        if (file.exists()) {
            if (override) {
                Profiles.exportProfile(file);
            }
        } else {
            Profiles.exportProfile(file);
        }
    }

    public static void loadProfile(String name) throws FileNotFoundException, CoreException {
        File file = new File(String.valueOf(Profiles.getProfileDirectory()) + File.separator + name);
        Profiles.importProfile(file);
    }

    public static void deleteProfile(String name) {
        File file = new File(String.valueOf(Profiles.getProfileDirectory()) + File.separator + name);
        file.delete();
    }

    public static void exportProfile(File file) throws FileNotFoundException, CoreException {
        IPreferenceFilter[] preferenceFilters = new IPreferenceFilter[]{new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "configuration"};
            }

            public Map getMapping(String scope) {
                return null;
            }
        }};
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IPreferencesService preferencesService = Platform.getPreferencesService();
        preferencesService.exportPreferences(preferencesService.getRootNode(), preferenceFilters, (OutputStream)fileOutputStream);
    }

    public static IStatus importProfile(File file) throws FileNotFoundException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IPreferencesService preferencesService = Platform.getPreferencesService();
        return preferencesService.importPreferences((InputStream)fileInputStream);
    }

    private static String getProfileDirectory() {
        return String.valueOf(ApplicationSettings.getSettingsDirectory().getAbsolutePath()) + File.separator + PACKAGE + File.separator + PROFILES;
    }
}

