/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Algorithm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.AnalysisSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PeakSettingsWizardPage
extends WizardPage {
    private IAnalysisSettings analysisSettings = new AnalysisSettings();
    private DataBindingContext dataBindingContext = new DataBindingContext();
    private IObservableValue<Double> retentionTimeWindow = new WritableValue();
    private Algorithm[] algorithms = Algorithm.getAlgorithms();

    public PeakSettingsWizardPage() {
        super("Main Properties");
        this.setTitle("PCA");
        this.setDescription("Set main PCA parameters.");
        this.retentionTimeWindow.setValue((Object)0.1);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dataBindingContext);
        this.createLabel(composite, "Retention Time Windows [min]:");
        this.createVariableSection(composite);
        this.createLabel(composite, "Number of PCs:");
        this.createSpinnerPrincipleComponents(composite);
        this.createLabel(composite, "Algorithm:");
        this.createComboViewerAlgorithm(composite);
        this.setControl((Control)composite);
    }

    public int getRetentionTimeWindow() {
        return (int)Math.round((Double)this.retentionTimeWindow.getValue() * 60000.0);
    }

    public IAnalysisSettings getAnalysisSettings() {
        return this.analysisSettings;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private void createVariableSection(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        UpdateValueStrategy widgetToModel = UpdateValueStrategy.create((IConverter)IConverter.create(String.class, Double.class, o1 -> {
            try {
                return Double.parseDouble((String)o1);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }));
        widgetToModel.setBeforeSetValidator(o1 -> {
            Double i;
            if (o1 instanceof Double && (i = (Double)o1) > 0.0) {
                return ValidationStatus.ok();
            }
            return ValidationStatus.error((String)"Warning: The value must be positive.");
        });
        UpdateValueStrategy modelToWidget = UpdateValueStrategy.create((IConverter)IConverter.create(Double.class, String.class, o1 -> Double.toString((Double)o1)));
        this.dataBindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), this.retentionTimeWindow, widgetToModel, modelToWidget);
    }

    private Spinner createSpinnerPrincipleComponents(Composite parent) {
        final Spinner spinner = new Spinner(parent, 2048);
        spinner.setToolTipText("Number of Principal Components");
        spinner.setMinimum(3);
        spinner.setIncrement(1);
        spinner.setSelection(this.analysisSettings.getNumberOfPrincipalComponents());
        spinner.setMaximum(1000);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PeakSettingsWizardPage.this.analysisSettings != null) {
                    PeakSettingsWizardPage.this.analysisSettings.setNumberOfPrincipalComponents(spinner.getSelection());
                }
            }
        });
        return spinner;
    }

    private ComboViewer createComboViewerAlgorithm(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput((Object)this.algorithms);
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Algorithm) {
                    return ((Algorithm)element).getName();
                }
                return null;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setToolTipText("PCA Algorithm");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof Algorithm && PeakSettingsWizardPage.this.analysisSettings != null) {
                    PeakSettingsWizardPage.this.analysisSettings.setAlgorithm((Algorithm)object);
                }
            }
        });
        combo.select(this.getSelectedAlgorithmIndex());
        return comboViewer;
    }

    private int getSelectedAlgorithmIndex() {
        int i = 0;
        while (i < this.algorithms.length) {
            Algorithm algorithm = this.algorithms[i];
            if (algorithm.equals((Object)this.analysisSettings.getAlgorithm())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

