/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point3D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.text.Font;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.chart3d.ScorePlot3DSettings;
import org.eclipse.chemclipse.support.text.ValueFormat;

public class ScorePlot3DAxes
extends Group {
    private final PhongMaterial cornMaterial = new PhongMaterial();
    private NumberFormat format;
    private final PhongMaterial gridaxisMaterial = new PhongMaterial();
    private double lableDistance;
    private double lableDistanceNameAxis;
    private final PhongMaterial planeMaterial = new PhongMaterial();
    private ScorePlot3DSettings settings;
    private double tickLenght;
    private double widthCorn;
    double sX = 1.0;
    double sY = 1.0;
    double sZ = 1.0;
    double lenghtX = 0.0;
    double lenghtY = 0.0;
    double lenghtZ = 0.0;
    private final DoubleProperty labelMaxWidth = new SimpleDoubleProperty();
    private Font labelFont = new Font("Arial", 35.0);
    private Font labelAxisFont = new Font("Arial", 50.0);

    public ScorePlot3DAxes(ScorePlot3DSettings settings) {
        this.settings = settings;
        double absMaximum = Arrays.stream(new double[]{settings.getMinX(), settings.getMaxX(), settings.getMinY(), settings.getMaxY(), settings.getMinZ(), settings.getMaxZ()}).map(d -> Math.abs(d)).max().getAsDouble();
        double numberDigits = Math.floor(Math.log10(absMaximum));
        if (Math.abs(numberDigits) > 4.0) {
            this.format = new DecimalFormat("#.##E0", new DecimalFormatSymbols(Locale.US));
        } else {
            this.format = ValueFormat.getNumberFormatEnglish();
            this.format.setMaximumFractionDigits(2);
        }
        this.cornMaterial.setDiffuseColor(Color.BLACK);
        this.cornMaterial.setSpecularColor(Color.BLACK.brighter());
        this.gridaxisMaterial.setDiffuseColor(Color.GRAY);
        this.gridaxisMaterial.setSpecularColor(Color.GRAY.brighter());
        this.planeMaterial.setDiffuseColor(Color.LIGHTGRAY);
        this.planeMaterial.setSpecularColor(Color.LIGHTGRAY.brighter());
        this.tickLenght = 40.0;
        this.lableDistance = 70.0;
        this.lableDistanceNameAxis = 270.0;
        this.widthCorn = 4.0;
        this.sX = settings.getScaleX();
        this.sY = settings.getScaleY();
        this.sZ = settings.getScaleZ();
        this.lenghtX = settings.getAxisXlenght();
        this.lenghtY = settings.getAxisYlenght();
        this.lenghtZ = settings.getAxisZlenght();
    }

    private Node createCorn(double height, Point3D rotation, double rotate, double translationX, double translationY, double translationZ, double lengthening) {
        Box corn = new Box(height + lengthening, this.widthCorn, this.widthCorn);
        corn.setRotationAxis(rotation);
        corn.setRotate(rotate);
        corn.setTranslateX(translationX);
        corn.setTranslateY(translationY);
        corn.setTranslateZ(translationZ);
        corn.setMaterial((Material)this.cornMaterial);
        return corn;
    }

    private Group createCorns() {
        Group group = new Group();
        Node corn = this.createCorn(this.lenghtX * this.sX, Rotate.X_AXIS, 0.0, 0.0, -this.lenghtY * this.sY / 2.0, -this.lenghtZ * this.sZ / 2.0, 500.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtX * this.sX, Rotate.X_AXIS, 0.0, 0.0, this.lenghtY * this.sY / 2.0, -this.lenghtZ * this.sZ / 2.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtX * this.sX, Rotate.X_AXIS, 0.0, 0.0, -this.lenghtY * this.sY / 2.0, this.lenghtZ * this.sZ / 2.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtX * this.sX, Rotate.X_AXIS, 0.0, 0.0, this.lenghtY * this.sY / 2.0, this.lenghtZ * this.sZ / 2.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtY * this.sY, Rotate.Z_AXIS, 90.0, -this.lenghtX * this.sX / 2.0, 0.0, -this.lenghtZ * this.sZ / 2.0, 500.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtY * this.sY, Rotate.Z_AXIS, 90.0, this.lenghtX * this.sX / 2.0, 0.0, -this.lenghtZ * this.sZ / 2.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtY * this.sY, Rotate.Z_AXIS, 90.0, -this.lenghtX * this.sX / 2.0, 0.0, this.lenghtZ * this.sZ / 2.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtY * this.sY, Rotate.Z_AXIS, 90.0, this.lenghtX * this.sX / 2.0, 0.0, this.lenghtZ * this.sZ / 2.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtZ * this.sZ, Rotate.Y_AXIS, 90.0, -this.lenghtX * this.sX / 2.0, -this.lenghtY * this.sY / 2.0, 0.0, 500.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtZ * this.sZ, Rotate.Y_AXIS, 90.0, this.lenghtX * this.sX / 2.0, -this.lenghtY * this.sY / 2.0, 0.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtZ * this.sZ, Rotate.Y_AXIS, 90.0, -this.lenghtX * this.sX / 2.0, this.lenghtY * this.sY / 2.0, 0.0, 0.0);
        group.getChildren().add((Object)corn);
        corn = this.createCorn(this.lenghtZ * this.sZ, Rotate.Y_AXIS, 90.0, this.lenghtX * this.sX / 2.0, this.lenghtY * this.sY / 2.0, 0.0, 0.0);
        group.getChildren().add((Object)corn);
        return group;
    }

    private Node createGridLine(Point3D origin, Point3D target) {
        Point3D yAxis = new Point3D(0.0, 1.0, 0.0);
        Point3D diff = target.subtract(origin);
        double height = diff.magnitude();
        Point3D mid = target.midpoint(origin);
        Translate moveToMidpoint = new Translate(mid.getX(), mid.getY(), mid.getZ());
        Point3D axisOfRotation = diff.crossProduct(yAxis);
        double angle = Math.acos(diff.normalize().dotProduct(yAxis));
        Rotate rotateAroundCenter = new Rotate(-Math.toDegrees(angle), axisOfRotation);
        Box line = new Box(2.0, height, 2.0);
        line.setMaterial((Material)this.gridaxisMaterial);
        line.getTransforms().addAll((Object[])new Transform[]{moveToMidpoint, rotateAroundCenter});
        return line;
    }

    private Group createPlane(double lenghtX, double lenghtY, double lineSpacingH, double lineSpacingV) {
        Group group = new Group();
        double lineSpacingScaled = lineSpacingH;
        double minX = -lenghtX / 2.0;
        double maxX = lenghtX / 2.0;
        int i = (int)(minX / lineSpacingScaled) + 1;
        while (i < (int)(maxX / lineSpacingScaled)) {
            group.getChildren().add((Object)this.createGridLine(new Point3D((double)i * lineSpacingScaled, -lenghtY / 2.0, 0.0), new Point3D((double)i * lineSpacingScaled, lenghtY / 2.0, 0.0)));
            ++i;
        }
        lineSpacingScaled = lineSpacingV;
        double minY = -lenghtY / 2.0;
        double maxY = lenghtY / 2.0;
        int i2 = (int)(minY / lineSpacingScaled) + 1;
        while (i2 < (int)(maxY / lineSpacingScaled)) {
            group.getChildren().add((Object)this.createGridLine(new Point3D(-lenghtX / 2.0, (double)i2 * lineSpacingScaled, 0.0), new Point3D(lenghtX / 2.0, (double)i2 * lineSpacingScaled, 0.0)));
            ++i2;
        }
        return group;
    }

    private Group createXYPlane() {
        Group group = this.createPlane(this.lenghtX * this.sX, this.lenghtY * this.sY, this.settings.getLineSpacingX() * this.sX, this.settings.getLineSpacingY() * this.sY);
        group.setTranslateZ(-this.lenghtZ * this.sZ / 2.0);
        return group;
    }

    private Group createXZPlane() {
        Group group = this.createPlane(this.lenghtX * this.sX, this.lenghtZ * this.sZ, this.settings.getLineSpacingX() * this.sX, this.settings.getLineSpacingZ() * this.sZ);
        group.setTranslateY(-this.lenghtY * this.sY / 2.0);
        group.setRotationAxis(Rotate.X_AXIS);
        group.setRotate(90.0);
        return group;
    }

    private Group createYZPlane() {
        Group group = this.createPlane(this.lenghtZ * this.sZ, this.lenghtY * this.sY, this.settings.getLineSpacingZ() * this.sZ, this.settings.getLineSpacingY() * this.sY);
        group.setTranslateX(-this.lenghtX * this.sX / 2.0);
        group.setRotationAxis(Rotate.Y_AXIS);
        group.setRotate(90.0);
        return group;
    }

    private Group createXLabels() {
        Group groupTick = new Group();
        Group groupLabel = new Group();
        String nameAxis = this.settings.getLabelAxisX();
        Label name = new Label(nameAxis);
        name.setTranslateZ(this.lableDistanceNameAxis);
        name.setRotationAxis(Rotate.X_AXIS);
        name.setRotate(90.0);
        this.setLabelStyleAxis(name);
        groupTick.getChildren().add((Object)name);
        double lineSpacingScaled = this.settings.getLineSpacingX() * this.sX;
        double minX = -this.lenghtX * this.sX / 2.0;
        double maxX = this.lenghtX * this.sX / 2.0;
        double minY = -this.lenghtY * this.sY / 2.0;
        double maxZ = this.lenghtZ * this.sZ / 2.0;
        boolean firstLabel = true;
        int i = (int)(minX / lineSpacingScaled) + 1;
        while (i < (int)(maxX / lineSpacingScaled)) {
            Label label = new Label(this.format.format((double)i * this.settings.getLineSpacingX() - this.settings.getShiftX()));
            if (firstLabel) {
                label.heightProperty().addListener((obs, oldVal, newVal) -> {
                    double labelHight = newVal.doubleValue();
                    groupLabel.setTranslateX((maxX - minX) / 2.0 + minX - labelHight / 2.0);
                });
                firstLabel = false;
            }
            label.widthProperty().addListener((obs, oldVal, newVal) -> {
                double value = newVal.doubleValue();
                if (value > this.labelMaxWidth.doubleValue()) {
                    this.labelMaxWidth.set(value);
                }
            });
            this.setLabelStyle(label);
            Rotate xRotate = new Rotate(90.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
            Rotate yRotate = new Rotate(90.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
            label.getTransforms().addAll((Object[])new Transform[]{yRotate, xRotate});
            label.setTranslateX((double)i * lineSpacingScaled);
            label.setTranslateZ(2.0 * this.lableDistance);
            Node tick = this.createGridLine(new Point3D((double)i * lineSpacingScaled, 0.0, -this.tickLenght / 2.0), new Point3D((double)i * lineSpacingScaled, 0.0, this.tickLenght / 2.0));
            groupTick.getChildren().add((Object)tick);
            groupLabel.getChildren().add((Object)label);
            ++i;
        }
        groupTick.setTranslateY(minY);
        groupTick.setTranslateZ(maxZ);
        groupTick.setTranslateX((maxX - minX) / 2.0 + minX);
        groupLabel.setTranslateY(minY);
        groupLabel.setTranslateZ(maxZ);
        Group group = new Group();
        group.getChildren().addAll((Object[])new Node[]{groupLabel, groupTick});
        return group;
    }

    private Group createYLabels() {
        Group groupLabel = new Group();
        Group groupTick = new Group();
        String axisName = this.settings.getLabelAxisY();
        Label name = new Label(axisName);
        Rotate zRotateAxis = new Rotate(-90.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);
        Rotate yRotateAxis = new Rotate(-90.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        name.getTransforms().addAll((Object[])new Transform[]{yRotateAxis, zRotateAxis});
        name.setTranslateZ(this.lableDistanceNameAxis);
        this.setLabelStyleAxis(name);
        groupTick.getChildren().add((Object)name);
        double minY = -this.lenghtY * this.sY / 2.0;
        double maxY = this.lenghtY * this.sY / 2.0;
        double maxZ = this.lenghtZ * this.sZ / 2.0;
        double minX = -this.lenghtX * this.sX / 2.0;
        double lineSpacingScaled = this.settings.getLineSpacingY() * this.sY;
        boolean firstLabel = true;
        int i = (int)(minY / lineSpacingScaled) + 1;
        while (i < (int)(maxY / lineSpacingScaled)) {
            Label label = new Label(this.format.format((double)i * this.settings.getLineSpacingY() - this.settings.getShiftY()));
            if (firstLabel) {
                label.heightProperty().addListener((obs, oldVal, newVal) -> {
                    double labelHight = newVal.doubleValue();
                    groupLabel.setTranslateY((maxY - minY) / 2.0 + minY + labelHight / 2.0);
                });
                firstLabel = false;
            }
            label.widthProperty().addListener((obs, oldVal, newVal) -> {
                double value = newVal.doubleValue();
                if (value > this.labelMaxWidth.doubleValue()) {
                    this.labelMaxWidth.set(value);
                }
            });
            this.setLabelStyle(label);
            Rotate xRotate = new Rotate(180.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
            Rotate yRotate = new Rotate(90.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
            label.getTransforms().addAll((Object[])new Transform[]{yRotate, xRotate});
            label.setTranslateY((double)i * lineSpacingScaled);
            label.setTranslateZ(2.0 * this.lableDistance);
            Node tick = this.createGridLine(new Point3D(0.0, (double)i * lineSpacingScaled, -this.tickLenght / 2.0), new Point3D(0.0, (double)i * lineSpacingScaled, this.tickLenght / 2.0));
            groupTick.getChildren().add((Object)tick);
            groupLabel.getChildren().add((Object)label);
            ++i;
        }
        groupLabel.setTranslateX(minX);
        groupLabel.setTranslateZ(maxZ);
        groupTick.setTranslateX(minX);
        groupTick.setTranslateZ(maxZ);
        groupTick.setTranslateY((maxY - minY) / 2.0 + minY);
        Group group = new Group();
        group.getChildren().addAll((Object[])new Node[]{groupLabel, groupTick});
        return group;
    }

    private Group createZLanels() {
        Group groupTick = new Group();
        Group groupLabel = new Group();
        String nameAxis = this.settings.getLabelAxisZ();
        Label name = new Label(nameAxis);
        Rotate yRotateAxis = new Rotate(90.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        Rotate zRotateAxis = new Rotate(-90.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);
        name.getTransforms().addAll((Object[])new Transform[]{zRotateAxis, yRotateAxis});
        name.setTranslateX(this.lableDistanceNameAxis);
        this.setLabelStyleAxis(name);
        groupTick.getChildren().add((Object)name);
        double minZ = -this.lenghtZ * this.sZ / 2.0;
        double maxZ = this.lenghtZ * this.sZ / 2.0;
        double maxX = this.lenghtX * this.sX / 2.0;
        double minY = -this.lenghtY * this.sY / 2.0;
        double lineSpacingScaled = this.settings.getLineSpacingZ() * this.sZ;
        int i = (int)(minZ / lineSpacingScaled) + 1;
        while (i < (int)(maxZ / lineSpacingScaled)) {
            Label label = new Label(this.format.format((double)i * this.settings.getLineSpacingZ() - this.settings.getShiftZ()));
            label.widthProperty().addListener((obs, oldVal, newVal) -> {
                double value = newVal.doubleValue();
                if (value > this.labelMaxWidth.doubleValue()) {
                    this.labelMaxWidth.set(value);
                }
            });
            this.setLabelStyle(label);
            label.setRotationAxis(Rotate.X_AXIS);
            label.setRotate(90.0);
            label.setTranslateZ((double)i * lineSpacingScaled);
            label.setTranslateX(2.0 * this.lableDistance);
            Node tick = this.createGridLine(new Point3D(-this.tickLenght / 2.0, 0.0, (double)i * lineSpacingScaled), new Point3D(this.tickLenght / 2.0, 0.0, (double)i * lineSpacingScaled));
            groupLabel.getChildren().add((Object)tick);
            groupLabel.getChildren().add((Object)label);
            ++i;
        }
        groupTick.setTranslateZ((maxZ - minZ) / 2.0 + minZ);
        groupTick.setTranslateX(maxX);
        groupTick.setTranslateY(minY);
        groupLabel.setTranslateZ((maxZ - minZ) / 2.0 + minZ);
        groupLabel.setTranslateX(maxX);
        groupLabel.setTranslateY(minY);
        Group group = new Group();
        group.getChildren().addAll((Object[])new Node[]{groupLabel, groupTick});
        return group;
    }

    public void buildAxes() {
        this.getChildren().setAll((Object[])new Node[]{this.createXYPlane(), this.createYZPlane(), this.createXZPlane(), this.createCorns(), this.createXLabels(), this.createYLabels(), this.createZLanels()});
    }

    private void setLabelStyle(Label label) {
        label.setAlignment(Pos.CENTER);
        label.setFont(this.labelFont);
    }

    private void setLabelStyleAxis(Label label) {
        label.setFont(this.labelAxisFont);
    }
}

