/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class TargetBuilder {
    private static final Logger logger = Logger.getLogger(TargetBuilder.class);
    private static final String UNKNOWN = "???";
    private static final float MAX_FACTOR = 100.0f;
    private final IonAbundanceComparator ionAbundanceComparator = new IonAbundanceComparator(SortOrder.DESC);

    public IIdentificationTarget getPeakTarget(IScanMSD reference, IComparisonResult comparisonResult, String identifier) {
        return this.getPeakTarget(reference, comparisonResult, identifier, "");
    }

    public IIdentificationTarget getPeakTarget(IScanMSD reference, IComparisonResult comparisonResult, String identifier, String database) {
        PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
        this.initializeLibraryInformation((ILibraryInformation)libraryInformation, reference);
        libraryInformation.setDatabase(database);
        IdentificationTarget peakTarget = null;
        try {
            peakTarget = new IdentificationTarget((ILibraryInformation)libraryInformation, comparisonResult);
            peakTarget.setIdentifier(identifier);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
        return peakTarget;
    }

    public void setPeakTargetUnknown(IPeakMSD peakMSD, String identifier) {
        try {
            IPeakMassSpectrum unknown = peakMSD.getExtractedMassSpectrum();
            ILibraryInformation libraryInformation = this.getLibraryInformationUnknown(unknown.getIons());
            IComparisonResult comparisonResult = this.getComparisonResultUnknown();
            IdentificationTarget peakTarget = new IdentificationTarget(libraryInformation, comparisonResult);
            peakTarget.setIdentifier(identifier);
            peakMSD.getTargets().add(peakTarget);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
    }

    public IIdentificationTarget getMassSpectrumTarget(IScanMSD reference, IComparisonResult comparisonResult, String identifier) {
        return this.getMassSpectrumTarget(reference, comparisonResult, identifier, "");
    }

    public IIdentificationTarget getMassSpectrumTarget(IScanMSD reference, IComparisonResult comparisonResult, String identifier, String database) {
        LibraryInformation libraryInformation = new LibraryInformation();
        this.initializeLibraryInformation((ILibraryInformation)libraryInformation, reference);
        libraryInformation.setDatabase(database);
        IdentificationTarget identificationEntry = null;
        try {
            identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, comparisonResult);
            identificationEntry.setIdentifier(identifier);
            identificationEntry.setLibraryScan((IScan)reference);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
        return identificationEntry;
    }

    public void setMassSpectrumTargetUnknown(IScanMSD unknown, String identifier) {
        try {
            ILibraryInformation libraryInformation = this.getLibraryInformationUnknown(unknown.getIons());
            IComparisonResult comparisonResult = this.getComparisonResultUnknown();
            IdentificationTarget massSpectrumTarget = new IdentificationTarget(libraryInformation, comparisonResult);
            massSpectrumTarget.setIdentifier(identifier);
            unknown.getTargets().add(massSpectrumTarget);
        }
        catch (ReferenceMustNotBeNullException e) {
            logger.warn((Object)e);
        }
    }

    private void initializeLibraryInformation(ILibraryInformation libraryInformation, IScanMSD reference) {
        if (reference instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)reference;
            ILibraryInformation libraryInformationReference = libraryMassSpectrum.getLibraryInformation();
            libraryInformation.setCasNumber(libraryInformationReference.getCasNumber());
            libraryInformation.setComments(libraryInformationReference.getComments());
            libraryInformation.setContributor(libraryInformationReference.getContributor());
            libraryInformation.setDatabase(libraryInformationReference.getDatabase());
            libraryInformation.setFormula(libraryInformationReference.getFormula());
            libraryInformation.setInChI(libraryInformationReference.getInChI());
            libraryInformation.setMiscellaneous(libraryInformationReference.getMiscellaneous());
            libraryInformation.setMolWeight(libraryInformationReference.getMolWeight());
            libraryInformation.setName(libraryInformationReference.getName());
            libraryInformation.setReferenceIdentifier(libraryInformationReference.getReferenceIdentifier());
            libraryInformation.setSmiles(libraryInformationReference.getSmiles());
            libraryInformation.setSynonyms(libraryInformationReference.getSynonyms());
            libraryInformationReference.getClassifier().forEach(arg_0 -> ((ILibraryInformation)libraryInformation).addClassifier(arg_0));
        } else {
            libraryInformation.setName(UNKNOWN);
            libraryInformation.setCasNumber(UNKNOWN);
            libraryInformation.setMiscellaneous(UNKNOWN);
        }
        libraryInformation.setRetentionTime(reference.getRetentionTime());
        libraryInformation.setRetentionIndex(reference.getRetentionIndex());
    }

    private ILibraryInformation getLibraryInformationUnknown(List<IIon> ions) {
        ions = new ArrayList<IIon>(ions);
        LibraryInformation libraryInformation = new LibraryInformation();
        Collections.sort(ions, this.ionAbundanceComparator);
        StringBuilder builder = new StringBuilder();
        builder.append("Unknown [");
        int size = ions.size() >= 5 ? 5 : ions.size();
        int i = 0;
        while (i < size) {
            builder.append((int)ions.get(i).getIon());
            if (i < size - 1) {
                builder.append(",");
            }
            ++i;
        }
        builder.append("]");
        libraryInformation.setName(builder.toString());
        return libraryInformation;
    }

    private IComparisonResult getComparisonResultUnknown() {
        return new ComparisonResult(100.0f, 100.0f, 100.0f, 100.0f);
    }
}

