/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class MassSpectrumIdentifierProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Scan Identifier";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IMassSpectrumIdentifierSupport support = MassSpectrumIdentifier.getMassSpectrumIdentifierSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableIdentifierIds()) {
                IMassSpectrumIdentifierSupplier supplier = support.getIdentifierSupplier(processorId);
                list.add((IProcessSupplier<?>)new MassSpectrumIdentifierProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIdentifierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class MassSpectrumIdentifierProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IMassSpectrumIdentifierSettings> {
        private IMassSpectrumIdentifierSupplier supplier;

        public MassSpectrumIdentifierProcessorSupplier(IMassSpectrumIdentifierSupplier supplier, IProcessTypeSupplier parent) {
            super("MassSpectrumIdentifier." + supplier.getId(), supplier.getIdentifierName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IMassSpectrumIdentifierSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                if (processSettings instanceof IMassSpectrumIdentifierSettings) {
                    messageConsumer.addMessages(MassSpectrumIdentifier.identify((IScanMSD)chromatogramSelectionMSD.getSelectedScan(), processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages(MassSpectrumIdentifier.identify((IScanMSD)chromatogramSelectionMSD.getSelectedScan(), this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getName(), "Only MSD chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

