/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.arw.core;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramImportConverter;
import org.eclipse.chemclipse.csd.converter.supplier.arw.internal.support.SpecificationValidator;
import org.eclipse.chemclipse.csd.converter.supplier.arw.io.ChromatogramReader;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramImportConverter<IChromatogramCSD> {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);
    private static final String DESCRIPTION = "Arw Import Converter";

    public IProcessingInfo<IChromatogramCSD> convert(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            try {
                IChromatogramCSD chromatogram = reader.read(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogram);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IProcessingInfo<IChromatogramOverview> convertOverview(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

