/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.PeakDetectorSettings;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.ChromatogramPeakMSD;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakProcessorSupport {
    public static final String PEAK_CONVERTER_ID = "org.eclipse.chemclipse.msd.converter.supplier.amdis.peak.elu";

    public void extractEluFileAndSetPeaks(IChromatogramSelectionMSD chromatogramSelection, File file, PeakDetectorSettings peakDetectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = PeakConverterMSD.convert((File)file, (String)PEAK_CONVERTER_ID, (IProgressMonitor)monitor);
        IPeaks peaks = (IPeaks)processingInfo.getProcessingResult();
        PeakProcessorSupport.insertPeaks(chromatogramSelection, peaks.getPeaks(), peakDetectorSettings, monitor);
    }

    public static IProcessingResult<Void> insertPeaks(IChromatogramSelectionMSD chromatogramSelection, List<IPeak> peaks, PeakDetectorSettings peakDetectorSettings, IProgressMonitor monitor) {
        DefaultProcessingResult result = new DefaultProcessingResult();
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startRetentionTime = chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
        for (IPeak peak : peaks) {
            if (!(peak instanceof IPeakMSD)) continue;
            try {
                IPeakMSD peakMSD = (IPeakMSD)peak;
                IPeakModelMSD peakModelMSD = peakMSD.getPeakModel();
                int startScan = peakModelMSD.getTemporarilyInfo("START_SCAN") instanceof Integer ? (Integer)peakModelMSD.getTemporarilyInfo("START_SCAN") : 0;
                int stopScan = peakModelMSD.getTemporarilyInfo("STOP_SCAN") instanceof Integer ? (Integer)peakModelMSD.getTemporarilyInfo("STOP_SCAN") : 0;
                int maxScan = peakModelMSD.getTemporarilyInfo("MAX_SCAN") instanceof Integer ? (Integer)peakModelMSD.getTemporarilyInfo("MAX_SCAN") : 0;
                ++startScan;
                ++stopScan;
                ++maxScan;
                ChromatogramPeakMSD chromatogramPeakMSD = new ChromatogramPeakMSD(peakModelMSD, chromatogram, "AMDIS Peak (ELU)");
                if (!PeakProcessorSupport.isValidPeak((IChromatogramPeakMSD)chromatogramPeakMSD, startRetentionTime, stopRetentionTime, peakDetectorSettings)) continue;
                try {
                    if (startScan > 0 && stopScan > startScan && maxScan > startScan) {
                        ArrayList<Integer> retentionTimes = new ArrayList<Integer>();
                        int scan = startScan;
                        while (scan <= stopScan) {
                            retentionTimes.add(chromatogram.getScan(scan).getRetentionTime());
                            ++scan;
                        }
                        chromatogramPeakMSD.getPeakModel().replaceRetentionTimes(retentionTimes);
                    }
                }
                catch (Exception e) {
                    result.addWarnMessage("AMDIS Identifier", "Pre check failed for peak: " + e);
                }
                chromatogram.addPeak((IPeak)chromatogramPeakMSD);
            }
            catch (IllegalArgumentException e) {
                result.addWarnMessage("AMDIS Identifier", "Adding AMDIS peak failed: " + e);
            }
            catch (PeakException e) {
                result.addWarnMessage("AMDIS Identifier", "Adding AMDIS peak failed: " + (Object)((Object)e));
            }
        }
        return result;
    }

    private static boolean isValidPeak(IChromatogramPeakMSD peak, int startRetentionTime, int stopRetentionTime, PeakDetectorSettings peakDetectorSettings) {
        if (peak == null) {
            return false;
        }
        IPeakModelMSD peakModel = peak.getPeakModel();
        if (peakModel.getStartRetentionTime() < startRetentionTime || peakModel.getStopRetentionTime() > stopRetentionTime) {
            return false;
        }
        if (peak.getSignalToNoiseRatio() < peakDetectorSettings.getMinSignalToNoiseRatio()) {
            return false;
        }
        float leading = peakModel.getLeading();
        if (leading < peakDetectorSettings.getMinLeading() || leading > peakDetectorSettings.getMaxLeading()) {
            return false;
        }
        float tailing = peakModel.getTailing();
        return !(tailing < peakDetectorSettings.getMinTailing()) && !(tailing > peakDetectorSettings.getMaxTailing());
    }
}

