/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparatorDynamicSettingProperty;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.support.settings.ComboSettingsProperty;
import org.eclipse.chemclipse.support.settings.DoubleSettingsProperty;
import org.eclipse.chemclipse.support.settings.EnumSelectionSettingProperty;

public class AmbiguousPeakRemoverFilterSettings {
    @JsonIgnore
    private final IChromatogramMSD chromatogram;
    @JsonProperty(value="Maximum RT (minutes)", defaultValue="0.05")
    @JsonPropertyDescription(value="The maximum distance between two consecutive peaks to select them for the filtering")
    @DoubleSettingsProperty
    private double rtmaxdistance = 0.05;
    @JsonProperty(value="Minimum matchfactor (0...1)", defaultValue="0.95")
    @JsonPropertyDescription(value="If the matchfactor is lower than this value we assume that two peaks are not equal")
    @DoubleSettingsProperty
    private double minmatchfactor = 0.95;
    @JsonProperty(value="Selection Method", defaultValue="SNR")
    @JsonPropertyDescription(value="Method to use for selecting the best peak in the group")
    @EnumSelectionSettingProperty
    private SelectionMethod method = SelectionMethod.SNR;
    @JsonProperty(value="m/z comparator", defaultValue="org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.distance.cosine")
    @JsonPropertyDescription(value="Method to use for comparing mass spectrums")
    @ComboSettingsProperty(value=MassSpectrumComparatorDynamicSettingProperty.class)
    private String comparatorID = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.distance.cosine";

    public AmbiguousPeakRemoverFilterSettings() {
        this(null);
    }

    public AmbiguousPeakRemoverFilterSettings(IChromatogramMSD chromatogram) {
        this.chromatogram = chromatogram;
        if (chromatogram == null) {
            this.setMethod(SelectionMethod.AREA);
        } else {
            this.setMethod(SelectionMethod.SNR);
        }
    }

    public double getRtMaxdistance() {
        return this.rtmaxdistance;
    }

    public void setRtMaxdistance(double rtmaxdistance) {
        this.rtmaxdistance = rtmaxdistance;
    }

    public double getMinmatchfactor() {
        return this.minmatchfactor;
    }

    public void setMinmatchfactor(double minmatchfactor) {
        this.minmatchfactor = minmatchfactor;
    }

    public String getComparatorID() {
        return this.comparatorID;
    }

    public void setComparatorID(String comparatorID) {
        this.comparatorID = comparatorID;
    }

    public SelectionMethod getMethod() {
        return this.method;
    }

    public void setMethod(SelectionMethod method) {
        this.method = method;
    }

    @JsonIgnore
    public IMassSpectrumComparator getMassSpectrumComparator() {
        return MassSpectrumComparator.getMassSpectrumComparator((String)this.getComparatorID());
    }

    public static enum SelectionMethod {
        SNR,
        AREA;

    }
}

