/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.baselinesubtract.core;

import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineFilter
extends AbstractChromatogramFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int i = startScan;
        while (i <= stopScan) {
            IScan scan = chromatogram.getScan(i);
            int retentionTime = scan.getRetentionTime();
            float backgroundSignal = baselineModel.getBackground(retentionTime);
            if (backgroundSignal > 0.0f) {
                scan.adjustTotalSignal(backgroundSignal);
            } else {
                scan.adjustTotalSignal(Float.MIN_VALUE);
            }
            ++i;
        }
        chromatogram.recalculateTheNoiseFactor();
        chromatogram.removeAllPeaks();
        baselineModel.removeBaseline();
        return new ProcessingInfo();
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        return this.applyFilter(chromatogramSelection, null, monitor);
    }
}

