/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.MassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.exceptions.NoMassSpectrumFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractMassspectrumFilterProcessTypeSupplier
implements IProcessTypeSupplier {
    private final String category;
    private final String prefix;
    private final Function<IChromatogramSelection<?, ?>, List<IScanMSD>> extractionFunction;

    public AbstractMassspectrumFilterProcessTypeSupplier(String category, String prefix, Function<IChromatogramSelection<?, ?>, List<IScanMSD>> extractionFunction) {
        this.category = category;
        this.prefix = prefix;
        this.extractionFunction = extractionFunction;
    }

    public String getCategory() {
        return this.category;
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IMassSpectrumFilterSupport filterSupport = MassSpectrumFilter.getMassSpectrumFilterSupport();
            ArrayList list = new ArrayList();
            for (String id : filterSupport.getAvailableFilterIds()) {
                list.add((IProcessSupplier<?>)new MassSpectrumFilterProcessorSupplier(this.prefix, filterSupport.getFilterSupplier(id), this.extractionFunction, this));
            }
            return list;
        }
        catch (NoMassSpectrumFilterSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class MassSpectrumFilterProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IMassSpectrumFilterSettings> {
        private final IMassSpectrumFilterSupplier supplier;
        private final Function<IChromatogramSelection<?, ?>, List<IScanMSD>> extractionFunction;

        public MassSpectrumFilterProcessorSupplier(String prefix, IMassSpectrumFilterSupplier supplier, Function<IChromatogramSelection<?, ?>, List<IScanMSD>> extractionFunction, IProcessTypeSupplier parent) {
            super(String.valueOf(prefix) + supplier.getId(), supplier.getFilterName(), supplier.getDescription(), supplier.getConfigClass(), parent, new DataType[]{DataType.MSD});
            this.supplier = supplier;
            this.extractionFunction = extractionFunction;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IMassSpectrumFilterSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            List<IScanMSD> massspectras = this.extractionFunction.apply(chromatogramSelection);
            messageConsumer.addMessages(MassSpectrumFilter.applyFilter(massspectras, processSettings, this.supplier.getId(), monitor));
            return chromatogramSelection;
        }
    }
}

