/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class DatabaseExportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(DatabaseExportRunnable.class);
    private File data;
    private File file;
    private IMassSpectra massSpectra;
    private ISupplier supplier;

    public DatabaseExportRunnable(File file, IMassSpectra massSpectra, ISupplier supplier) {
        this.file = file;
        this.massSpectra = massSpectra;
        this.supplier = supplier;
    }

    public File getData() {
        return this.data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Export Mass Spectra", -1);
            IProcessingInfo processingInfo = DatabaseConverter.convert((File)this.file, (IMassSpectra)this.massSpectra, (boolean)false, (String)this.supplier.getId(), (IProgressMonitor)monitor);
            this.data = (File)processingInfo.getProcessingResult();
        }
        finally {
            monitor.done();
        }
    }
}

