/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class IonListLabelProvider
extends AbstractChemClipseLabelProvider {
    public IonListLabelProvider() {
        super("0.0###");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IIon) {
            IIon ion = (IIon)element;
            IIonTransition ionTransition = ion.getIonTransition();
            switch (columnIndex) {
                case 0: {
                    String mz = decimalFormat.format(ion.getIon());
                    text = ionTransition == null ? mz : String.valueOf(Integer.toString((int)ionTransition.getQ1StartIon())) + " > " + mz;
                    break;
                }
                case 1: {
                    text = decimalFormat.format(ion.getAbundance());
                    break;
                }
                case 2: {
                    text = ionTransition == null ? "" : decimalFormat.format(ionTransition.getQ1Ion());
                    break;
                }
                case 3: {
                    text = ionTransition == null ? "" : decimalFormat.format(ionTransition.getQ1Resolution());
                    break;
                }
                case 4: {
                    text = ionTransition == null ? "" : decimalFormat.format(ionTransition.getQ3Ion());
                    break;
                }
                case 5: {
                    text = ionTransition == null ? "" : decimalFormat.format(ionTransition.getQ3Resolution());
                    break;
                }
                case 6: {
                    text = ionTransition == null ? "" : decimalFormat.format(ionTransition.getCollisionEnergy());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/ion.gif", "16x16");
    }
}

