/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.converter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConverterMSD {
    private ConverterMSD() {
    }

    public static List<IIon> getFilteredIons(IScanMSD massSpectrum) {
        ArrayList<IIon> ions;
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        boolean filterMassSpectrum = preferences.getBoolean("filterMassSpectrum", false);
        int filterLimitIons = preferences.getInt("filterLimitIons", 8000);
        int numberOfIons = massSpectrum.getNumberOfIons();
        if (filterMassSpectrum && numberOfIons > filterLimitIons) {
            ions = new ArrayList();
            float[] intensities = new float[massSpectrum.getIons().size()];
            int i = 0;
            for (IIon ion : massSpectrum.getIons()) {
                intensities[i++] = ion.getAbundance();
            }
            float maxIntensity = Calculations.getMax((float[])intensities);
            float medianIntensity = Calculations.getMedian((float[])intensities);
            float limitIntensity = medianIntensity + (maxIntensity - medianIntensity) / 6.0f;
            int moduloValue = numberOfIons / 100;
            int j = 0;
            for (IIon ion : massSpectrum.getIons()) {
                float intensity = ion.getAbundance();
                if (intensity >= limitIntensity) {
                    ions.add(ion);
                } else if (moduloValue > 0 && j % moduloValue == 0) {
                    ions.add(ion);
                }
                ++j;
            }
        } else {
            ions = new ArrayList<IIon>(massSpectrum.getIons());
        }
        return ions;
    }
}

