/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.Activator;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_SPLIT_LIBRARY = "splitLibrary";
    public static final boolean DEF_SPLIT_LIBRARY = false;
    public static final String P_EXCLUDE_UNCERTAIN_IONS = "excludeUncertainIons";
    public static final boolean DEF_EXCLUDE_UNCERTAIN_IONS = false;
    public static final String P_USE_UNIT_MASS_RESOLUTION = "useUnitMassResolution";
    public static final boolean DEF_USE_UNIT_MASS_RESOLUTION = true;
    public static final String P_REMOVE_INTENSITIES_LOWER_THAN_ONE = "removeIntensitiesLowerThanOne";
    public static final boolean DEF_REMOVE_INTENSITIES_LOWER_THAN_ONE = true;
    public static final String P_NORMALIZE_INTENSITIES = "normalizeIntensities";
    public static final boolean DEF_NORMALIZE_INTENSITIES = true;
    public static final String P_EXPORT_INTENSITIES_AS_INTEGER = "exportIntensitiesAsInteger";
    public static final boolean DEF_EXPORT_INTENSITIES_AS_INTEGER = true;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_SPLIT_LIBRARY, Boolean.toString(false));
        defaultValues.put(P_EXCLUDE_UNCERTAIN_IONS, Boolean.toString(false));
        defaultValues.put(P_USE_UNIT_MASS_RESOLUTION, Boolean.toString(true));
        defaultValues.put(P_REMOVE_INTENSITIES_LOWER_THAN_ONE, Boolean.toString(true));
        defaultValues.put(P_NORMALIZE_INTENSITIES, Boolean.toString(true));
        defaultValues.put(P_EXPORT_INTENSITIES_AS_INTEGER, Boolean.toString(true));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static boolean isSplitLibrary() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_SPLIT_LIBRARY, false);
    }

    public static boolean isExcludeUncertainIons() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_EXCLUDE_UNCERTAIN_IONS, false);
    }

    public static boolean isUseUnitMassResolution() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_USE_UNIT_MASS_RESOLUTION, true);
    }

    public static boolean isRemoveIntensitiesLowerThanOne() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_REMOVE_INTENSITIES_LOWER_THAN_ONE, true);
    }

    public static boolean isNormalizeIntensities() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_NORMALIZE_INTENSITIES, true);
    }

    public static boolean isExportIntensitiesAsInteger() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_EXPORT_INTENSITIES_AS_INTEGER, true);
    }
}

