/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.alfassi.comparator;

import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.AbstractMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.math.GeometricDistanceCalculator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.MatchConstraints;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;

public class MassSpectrumComparator
extends AbstractMassSpectrumComparator
implements IMassSpectrumComparator {
    public static final String COMPARATOR_ID = "org.eclipse.chemclipse.chromatogram.msd.comparison.supplier.alfassi.geometric";
    private static final int NORMALIZATION_FACTOR = 100;
    private static final Logger logger = Logger.getLogger(MassSpectrumComparator.class);

    public IProcessingInfo<IComparisonResult> compare(IScanMSD unknown, IScanMSD reference, MatchConstraints matchConstraints) {
        IProcessingInfo processingInfo = super.validate(unknown, reference);
        if (!processingInfo.hasErrorMessages()) {
            try {
                GeometricDistanceCalculator geometricDistanceCalculator = new GeometricDistanceCalculator();
                IScanMSD unknownAdjusted = this.adjustMassSpectrum(unknown);
                IScanMSD referenceAdjusted = this.adjustMassSpectrum(reference);
                IExtractedIonSignal signalU = unknownAdjusted.getExtractedIonSignal();
                IExtractedIonSignal signalR = referenceAdjusted.getExtractedIonSignal();
                float matchFactor = geometricDistanceCalculator.calculate(unknownAdjusted, referenceAdjusted, signalU.getIonRange()) * 100.0f;
                float reverseMatchFactor = geometricDistanceCalculator.calculate(referenceAdjusted, unknownAdjusted, signalR.getIonRange()) * 100.0f;
                float matchFactorDirect = geometricDistanceCalculator.calculate(unknownAdjusted, referenceAdjusted) * 100.0f;
                float reverseMatchFactorDirect = geometricDistanceCalculator.calculate(referenceAdjusted, unknownAdjusted) * 100.0f;
                ComparisonResult massSpectrumComparisonResult = new ComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect);
                processingInfo.setProcessingResult((Object)massSpectrumComparisonResult);
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Alfassi MassSpectrum Comparator", "The mass spectrum couldn't be cloned.");
            }
        }
        return processingInfo;
    }

    private IScanMSD adjustMassSpectrum(IScanMSD massSpectrum) throws CloneNotSupportedException {
        IScanMSD massSpectrumNormalized = massSpectrum.makeDeepCopy();
        massSpectrumNormalized.normalize(100.0f);
        return massSpectrumNormalized;
    }
}

