/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.PeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.processor.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.PeakIntegrationSettings;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIntegratorSupport {
    public IPeakIntegrationResults calculatePeakIntegrationResults(List<? extends IPeak> peaks, PeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        PeakIntegrationResults peakIntegrationResults;
        monitor.subTask("Integrate the peaks");
        if (peaks != null) {
            PeakIntegrator peakIntegrator = new PeakIntegrator();
            peakIntegrationResults = peakIntegrator.integrate(peaks, peakIntegrationSettings, monitor);
        } else {
            peakIntegrationResults = new PeakIntegrationResults();
        }
        return peakIntegrationResults;
    }

    public IPeakIntegrationResults calculatePeakIntegrationResults(IChromatogramSelection chromatogramSelection, PeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        List peaks = null;
        if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
            IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
            IChromatogramMSD chromatogramMSD = chromatogramSelectionMSD.getChromatogramMSD();
            peaks = chromatogramMSD.getPeaks((IRetentionTimeRange)chromatogramSelectionMSD);
        } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
            IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)chromatogramSelection;
            IChromatogramCSD chromatogramFID = chromatogramSelectionCSD.getChromatogramCSD();
            peaks = chromatogramFID.getPeaks((IRetentionTimeRange)chromatogramSelectionCSD);
        } else if (chromatogramSelection instanceof IChromatogramSelectionWSD) {
            IChromatogramSelectionWSD chromatogramSelectionWSD = (IChromatogramSelectionWSD)chromatogramSelection;
            IChromatogramWSD chromatogramWSD = chromatogramSelectionWSD.getChromatogramWSD();
            peaks = chromatogramWSD.getPeaks((IRetentionTimeRange)chromatogramSelectionWSD);
        }
        return this.calculatePeakIntegrationResults(peaks, peakIntegrationSettings, monitor);
    }

    public IPeakIntegrationResult calculatePeakIntegrationResult(IPeak peak, PeakIntegrationSettings peakIntegrationSettings, IProgressMonitor monitor) throws ValueMustNotBeNullException {
        monitor.subTask("Integrate the peak");
        PeakIntegrator peakIntegrator = new PeakIntegrator();
        IPeakIntegrationResult peakIntegrationResult = peakIntegrator.integrate(peak, peakIntegrationSettings, monitor);
        return peakIntegrationResult;
    }
}

