/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.support.AnalysisSupport;
import org.eclipse.chemclipse.model.support.IAnalysisSegment;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.support.IIonUniquenessValues;
import org.eclipse.chemclipse.msd.model.core.support.IonUniquenessValues;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;

public class ExtractedIonSignalsModifier {
    private static final Logger logger = Logger.getLogger(ExtractedIonSignalsModifier.class);
    private static final int SELECTION_PARTS = 10;
    private static final int MIN_SELECTION_WIDTH = 10;

    private ExtractedIonSignalsModifier() {
    }

    public static IIonUniquenessValues calculateIonUniqueness(IExtractedIonSignals extractedIonSignals) throws AnalysisSupportException {
        ExtractedIonSignalsModifier.validateChromatogram(extractedIonSignals);
        IScanRange scanRange = ExtractedIonSignalsModifier.calculateScanRange(extractedIonSignals);
        int segmentWidth = scanRange.getWidth();
        AnalysisSupport analysisSupport = new AnalysisSupport(scanRange, segmentWidth);
        List analysisSegments = analysisSupport.getAnalysisSegments();
        int startIon = extractedIonSignals.getStartIon();
        int stopIon = extractedIonSignals.getStopIon();
        IonUniquenessValues ionUniquenessValues = new IonUniquenessValues();
        for (IAnalysisSegment analysisSegment : analysisSegments) {
            int ion = startIon;
            while (ion <= stopIon) {
                float uniquenessValue = ExtractedIonSignalsModifier.calculateIonUniquenessValue(analysisSegment, ion, extractedIonSignals);
                ionUniquenessValues.add(ion, uniquenessValue);
                ++ion;
            }
        }
        return ionUniquenessValues;
    }

    public static void adjustThresholdTransitions(IExtractedIonSignals extractedIonSignals) throws AnalysisSupportException {
        ExtractedIonSignalsModifier.validateChromatogram(extractedIonSignals);
        IChromatogramMSD chromatogram = extractedIonSignals.getChromatogram();
        IScanRange scanRange = ExtractedIonSignalsModifier.calculateScanRange(extractedIonSignals);
        int segmentWidth = ExtractedIonSignalsModifier.calculateSegmentWidth(scanRange);
        AnalysisSupport analysisSupport = new AnalysisSupport(scanRange, segmentWidth);
        List analysisSegments = analysisSupport.getAnalysisSegments();
        float preSetThresholdAbundanceValue = chromatogram.getMinIonAbundance();
        int startIon = extractedIonSignals.getStartIon();
        int stopIon = extractedIonSignals.getStopIon();
        for (IAnalysisSegment analysisSegment : analysisSegments) {
            int ion = startIon;
            while (ion <= stopIon) {
                ExtractedIonSignalsModifier.adjustIonIntensities(analysisSegment, ion, preSetThresholdAbundanceValue, extractedIonSignals);
                ++ion;
            }
        }
    }

    private static int calculateSegmentWidth(IScanRange scanRange) {
        int selectionWidth = scanRange.getWidth();
        int segmentWidth = selectionWidth / 10;
        if (segmentWidth < 10) {
            segmentWidth = 10;
        }
        if (segmentWidth > selectionWidth) {
            segmentWidth = selectionWidth;
        }
        return segmentWidth;
    }

    private static IScanRange calculateScanRange(IExtractedIonSignals extractedIonSignals) throws AnalysisSupportException {
        int startScan = extractedIonSignals.getStartScan();
        int stopScan = extractedIonSignals.getStopScan();
        ScanRange scanRange = new ScanRange(startScan, stopScan);
        return scanRange;
    }

    private static void validateChromatogram(IExtractedIonSignals extractedIonSignals) throws AnalysisSupportException {
        ExtractedIonSignalsModifier.validateExtractedIonSignals(extractedIonSignals);
        IChromatogramMSD chromatogram = extractedIonSignals.getChromatogram();
        if (chromatogram == null) {
            throw new AnalysisSupportException("There is no chromatogram stored in the extracted ion signals instance.");
        }
    }

    private static void validateExtractedIonSignals(IExtractedIonSignals extractedIonSignals) throws AnalysisSupportException {
        if (extractedIonSignals == null) {
            throw new AnalysisSupportException("The extracted ion signals object is null.");
        }
    }

    private static float calculateIonUniquenessValue(IAnalysisSegment analysisSegment, int ion, IExtractedIonSignals extractedIonSignals) {
        int startScan = analysisSegment.getStartScan();
        int stopScan = analysisSegment.getStopScan();
        int width = analysisSegment.getSegmentWidth();
        float result = 0.0f;
        int transitions = ExtractedIonSignalsModifier.calculateTransitions(startScan, stopScan, extractedIonSignals, ion);
        float valuesNotZero = width - transitions;
        if (width > 0) {
            result = valuesNotZero / (float)width;
        }
        return result;
    }

    private static void adjustIonIntensities(IAnalysisSegment analysisSegment, int ion, float preSetThresholdAbundanceValue, IExtractedIonSignals extractedIonSignals) {
        double transitionFraction;
        int startScan = analysisSegment.getStartScan();
        int stopScan = analysisSegment.getStopScan();
        double transitions = ExtractedIonSignalsModifier.calculateTransitions(startScan, stopScan, extractedIonSignals, ion);
        int width = analysisSegment.getSegmentWidth();
        if (width > 0 && (transitionFraction = transitions / (double)width) > 0.0) {
            float adjustedNonZeroAbundanceValue = (float)((double)preSetThresholdAbundanceValue * Math.sqrt(transitionFraction));
            ExtractedIonSignalsModifier.setNewAbundanceValue(analysisSegment, extractedIonSignals, ion, adjustedNonZeroAbundanceValue);
        }
    }

    private static void setNewAbundanceValue(IAnalysisSegment analysisSegment, IExtractedIonSignals extractedIonSignals, int ion, float adjustedNonZeroAbundanceValue) {
        int startScan = analysisSegment.getStartScan();
        int stopScan = analysisSegment.getStopScan();
        float actualSignal = 0.0f;
        int scan = startScan;
        while (scan <= stopScan) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                actualSignal = extractedIonSignal.getAbundance(ion);
                if (actualSignal == 0.0f) {
                    extractedIonSignal.setAbundance(ion, adjustedNonZeroAbundanceValue, true);
                }
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
    }

    private static int calculateTransitions(int startScan, int stopScan, IExtractedIonSignals extractedIonSignals, int ion) {
        float actualSignal = 0.0f;
        int transitions = 0;
        boolean isZero = true;
        try {
            isZero = ExtractedIonSignalsModifier.isZero(extractedIonSignals, startScan, ion);
        }
        catch (NoExtractedIonSignalStoredException e) {
            logger.warn((Object)e);
        }
        int scan = ++startScan;
        while (scan <= stopScan) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                actualSignal = extractedIonSignal.getAbundance(ion);
                if (!isZero && actualSignal == 0.0f) {
                    ++transitions;
                    isZero = true;
                }
                if (actualSignal > 0.0f) {
                    isZero = false;
                }
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
        return transitions;
    }

    private static boolean isZero(IExtractedIonSignals extractedIonSignals, int scan, int ion) throws NoExtractedIonSignalStoredException {
        boolean isZero = false;
        IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
        if (extractedIonSignal.getAbundance(ion) == 0.0f) {
            isZero = true;
        }
        return isZero;
    }
}

