/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.Activator;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    private static final Logger logger = Logger.getLogger(PreferenceSupplier.class);
    public static final int MIN_TRACES = 1;
    public static final int MAX_TRACES = Integer.MAX_VALUE;
    public static final String P_SUBTRACT_MASS_SPECTRUM = "subtractMassSpectrum";
    public static final String DEF_SUBTRACT_MASS_SPECTRUM = "18:200;28:1000;32:500";
    public static final String P_USE_NOMINAL_MZ = "useNominalMZ";
    public static final boolean DEF_USE_NOMINAL_MZ = true;
    public static final String P_USE_NORMALIZED_SCAN = "useNormalizedScan";
    public static final boolean DEF_USE_NORMALIZED_SCAN = true;
    public static final String P_COPY_TRACES_CLIPBOARD = "copyTracesClipboard";
    public static final int DEF_COPY_TRACES_CLIPBOARD = 5;
    private static final String DELIMITER_ION_ABUNDANCE = ":";
    private static final String DELIMITER_IONS = ";";
    private static IScanMSD sessionSubtractMassSpectrum;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_SUBTRACT_MASS_SPECTRUM, DEF_SUBTRACT_MASS_SPECTRUM);
        defaultValues.put(P_USE_NOMINAL_MZ, Boolean.toString(true));
        defaultValues.put(P_USE_NORMALIZED_SCAN, Boolean.toString(true));
        defaultValues.put(P_COPY_TRACES_CLIPBOARD, Integer.toString(5));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static void loadSessionSubtractMassSpectrum() {
        IScanMSD subtractMassSpectrum = PreferenceSupplier.getSubtractMassSpectrum();
        PreferenceSupplier.setSessionSubtractMassSpectrum(subtractMassSpectrum);
    }

    public static void storeSessionSubtractMassSpectrum() {
        PreferenceSupplier.setSubtractMassSpectrum(sessionSubtractMassSpectrum);
    }

    public static IScanMSD getSessionSubtractMassSpectrum() {
        return sessionSubtractMassSpectrum;
    }

    public static void setSessionSubtractMassSpectrum(IScanMSD subtractMassSpectrum) {
        sessionSubtractMassSpectrum = subtractMassSpectrum;
    }

    public static boolean isUseNominalMZ() {
        return PreferenceSupplier.getBoolean(P_USE_NOMINAL_MZ, true);
    }

    public static void setUseNominalMZ(boolean useNominalMZ) {
        PreferenceSupplier.setBoolean(P_USE_NOMINAL_MZ, useNominalMZ);
    }

    public static boolean isUseNormalizedScan() {
        return PreferenceSupplier.getBoolean(P_USE_NORMALIZED_SCAN, true);
    }

    public static void setUseNormalizedScan(boolean useNormalizedScan) {
        PreferenceSupplier.setBoolean(P_USE_NORMALIZED_SCAN, useNormalizedScan);
    }

    public static String getSessionSubtractMassSpectrumAsString() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_SUBTRACT_MASS_SPECTRUM, DEF_SUBTRACT_MASS_SPECTRUM);
    }

    public static String getMassSpectrum(IScanMSD massSpectrum) {
        StringBuilder builder = new StringBuilder();
        if (massSpectrum != null) {
            for (IIon ion : massSpectrum.getIons()) {
                builder.append(ion.getIon());
                builder.append(DELIMITER_ION_ABUNDANCE);
                builder.append(ion.getAbundance());
                builder.append(DELIMITER_IONS);
            }
        }
        return builder.toString();
    }

    public static IScanMSD getMassSpectrum(String value) {
        if (value != null && !value.isEmpty()) {
            String[] ions;
            ScanMSD scanMSD = new ScanMSD();
            String[] stringArray = ions = value.split(DELIMITER_IONS);
            int n = ions.length;
            int n2 = 0;
            while (n2 < n) {
                String ion = stringArray[n2];
                String[] fragment = ion.split(DELIMITER_ION_ABUNDANCE);
                if (fragment.length == 2) {
                    double mz = Double.parseDouble(fragment[0]);
                    float abundance = Float.parseFloat(fragment[1]);
                    try {
                        Ion subtractIon = new Ion(mz, abundance);
                        scanMSD.addIon(subtractIon);
                    }
                    catch (AbundanceLimitExceededException e) {
                        logger.warn((Object)e);
                    }
                    catch (IonLimitExceededException e) {
                        logger.warn((Object)e);
                    }
                }
                ++n2;
            }
            return scanMSD;
        }
        return null;
    }

    public static int getMaxCopyTraces() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_COPY_TRACES_CLIPBOARD, 5);
    }

    private static IScanMSD getSubtractMassSpectrum() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String value = preferences.get(P_SUBTRACT_MASS_SPECTRUM, DEF_SUBTRACT_MASS_SPECTRUM);
        return PreferenceSupplier.getMassSpectrum(value);
    }

    private static void setSubtractMassSpectrum(IScanMSD massSpectrum) {
        try {
            String value = PreferenceSupplier.getMassSpectrum(massSpectrum);
            IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
            preferences.put(P_SUBTRACT_MASS_SPECTRUM, value);
            preferences.flush();
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private static boolean getBoolean(String key, boolean def) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(key, def);
    }

    private static void setBoolean(String key, boolean value) {
        try {
            IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
            preferences.putBoolean(key, value);
            preferences.flush();
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }
}

