/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;

public abstract class AbstractMarkedIons
implements IMarkedIons {
    private Set<IMarkedIon> markedIons = new HashSet<IMarkedIon>();

    protected AbstractMarkedIons(int[] ionsList) {
        if (ionsList != null) {
            int[] nArray = ionsList;
            int n = ionsList.length;
            int n2 = 0;
            while (n2 < n) {
                int ion = nArray[n2];
                this.markedIons.add(new MarkedIon(ion));
                ++n2;
            }
        }
    }

    protected AbstractMarkedIons(Collection<? extends Number> ionsList) {
        if (ionsList != null) {
            for (Number number : ionsList) {
                this.markedIons.add(new MarkedIon(number.intValue()));
            }
        }
    }

    public boolean add(IMarkedIon e) {
        return this.markedIons.add(e);
    }

    public boolean addAll(Collection<? extends IMarkedIon> c) {
        return this.markedIons.addAll(c);
    }

    public void clear() {
        this.markedIons.clear();
    }

    public boolean contains(Object o) {
        return this.markedIons.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.markedIons.containsAll(c);
    }

    public boolean isEmpty() {
        return this.markedIons.isEmpty();
    }

    public Iterator<IMarkedIon> iterator() {
        return this.markedIons.iterator();
    }

    public boolean remove(Object o) {
        return this.markedIons.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return this.markedIons.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.markedIons.retainAll(c);
    }

    public int size() {
        return this.markedIons.size();
    }

    public Object[] toArray() {
        return this.markedIons.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.markedIons.toArray(a);
    }

    @Override
    public Set<Integer> getIonsNominal() {
        HashSet<Integer> nominalIons = new HashSet<Integer>();
        for (IMarkedIon markedIon : this.markedIons) {
            nominalIons.add(AbstractIon.getIon(markedIon.getIon()));
        }
        return nominalIons;
    }

    @Override
    public void add(int ionStart, int ionStop) {
        if (ionStart > ionStop) {
            int tmp = ionStart;
            ionStart = ionStop;
            ionStop = tmp;
        }
        int i = ionStart;
        while (i <= ionStop) {
            this.markedIons.add(new MarkedIon(i));
            ++i;
        }
    }

    @Override
    public void add(int ... ions) {
        int[] nArray = ions;
        int n = ions.length;
        int n2 = 0;
        while (n2 < n) {
            int ion = nArray[n2];
            this.markedIons.add(new MarkedIon(ion));
            ++n2;
        }
    }

    @Override
    public void add(Collection<Integer> ions) {
        for (int ion : ions) {
            this.markedIons.add(new MarkedIon(ion));
        }
    }
}

