/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IScanIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonIsNullException;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.IonTransitionIsNullException;

public abstract class AbstractScanIon
extends AbstractIon
implements IScanIon {
    private static final long serialVersionUID = 892026628429907833L;
    private boolean ignoreAbundanceLimit = false;

    public AbstractScanIon(double ion) throws IonLimitExceededException {
        super(ion);
    }

    public AbstractScanIon(double ion, boolean ignoreAbundanceLimit) throws IonLimitExceededException {
        super(ion);
        this.ignoreAbundanceLimit = ignoreAbundanceLimit;
    }

    public AbstractScanIon(double ion, float abundance) throws AbundanceLimitExceededException, IonLimitExceededException {
        super(ion, abundance);
    }

    public AbstractScanIon(double ion, float abundance, IIonTransition ionTransition) throws AbundanceLimitExceededException, IonLimitExceededException, IonTransitionIsNullException {
        super(ion, abundance, ionTransition);
    }

    public AbstractScanIon(IIon ion, IIonTransition ionTransition) throws AbundanceLimitExceededException, IonLimitExceededException, IonIsNullException, IonTransitionIsNullException {
        super(ion, ionTransition);
    }

    public AbstractScanIon(IIon ion) throws AbundanceLimitExceededException, IonLimitExceededException, IonIsNullException {
        super(ion);
    }

    @Override
    public AbstractScanIon setAbundance(float abundance) throws AbundanceLimitExceededException {
        if (this.ignoreAbundanceLimit) {
            super.setAbundance(abundance);
        } else {
            if (abundance < this.getMinPossibleAbundanceValue() || abundance > this.getMaxPossibleAbundanceValue() || Float.isNaN(abundance)) {
                throw new AbundanceLimitExceededException("The value abundance: " + abundance + " is out of limit " + this.getMinPossibleAbundanceValue() + " - " + this.getMaxPossibleAbundanceValue());
            }
            super.setAbundance(abundance);
        }
        return this;
    }

    @Override
    public AbstractScanIon setIon(double ion) throws IonLimitExceededException {
        if (ion == 0.0) {
            super.setIon(ion);
        } else {
            if (ion < this.getMinPossibleIonValue() || ion > this.getMaxPossibleIonValue() || Double.isNaN(ion)) {
                throw new IonLimitExceededException("The value ion: " + ion + " is out of limit " + this.getMinPossibleIonValue() + " - " + this.getMaxPossibleIonValue());
            }
            super.setIon(ion);
        }
        return this;
    }

    @Override
    public boolean isIgnoreAbundanceLimit() {
        return this.ignoreAbundanceLimit;
    }

    @Override
    public void setIgnoreAbundanceLimit(boolean ignoreAbundanceLimit) {
        this.ignoreAbundanceLimit = ignoreAbundanceLimit;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (super.equals(otherObject)) {
            AbstractScanIon ion = (AbstractScanIon)otherObject;
            return this.ignoreAbundanceLimit == ion.isIgnoreAbundanceLimit();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 7 * Boolean.valueOf(this.ignoreAbundanceLimit).hashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("ignoreAbundanceLimit=" + this.ignoreAbundanceLimit);
        builder.append(",");
        builder.append("maxPossibleAbundanceValue=" + this.getMaxPossibleAbundanceValue());
        builder.append(",");
        builder.append("maxPossibleIonValue=" + this.getMaxPossibleIonValue());
        builder.append(",");
        builder.append("lowestInvalidAbundanceValue=" + this.getMinPossibleAbundanceValue());
        builder.append(",");
        builder.append("minPossibleIonValue=" + this.getMinPossibleIonValue());
        builder.append("]");
        return builder.toString();
    }
}

