/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.io.File;
import java.util.Date;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.CalibrationFileWriter;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PageCalibrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PageCalibrationTable;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PagePeakAssignment;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.PagePeakSelection;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.RetentionIndexWizardElements;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.ui.wizards.AbstractFileWizard;
import org.eclipse.chemclipse.support.ui.wizards.ChromatogramWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.IChromatogramWizardElements;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputEntriesWizardPage;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputWizardSettings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;

public class WizardCreateRetentionIndexFile
extends AbstractFileWizard {
    public static final int PREFERRED_WIDTH = 300;
    public static final int PREFERRED_HEIGHT = 600;
    private static final Logger logger = Logger.getLogger(WizardCreateRetentionIndexFile.class);
    private IRetentionIndexWizardElements wizardElements = new RetentionIndexWizardElements();
    private static final String CALIBRATION_FILE_EXTENSION = ".cal";
    private static final String CHROMATOGRAM_FILE_EXTENSION = ".ocb";
    private static final String CHROMATOGRAM_CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse";
    private PageCalibrationSettings pageCalibrationSettings;
    private InputEntriesWizardPage pageInputEntriesMSD;
    private InputEntriesWizardPage pageInputEntriesCSD;
    private PagePeakSelection pagePeakSelection;
    private PagePeakAssignment pagePeakAssignment;
    private PageCalibrationTable pageCalibrationTable;

    public WizardCreateRetentionIndexFile() {
        super("RetentionIndices_" + new Date().getTime(), CALIBRATION_FILE_EXTENSION);
    }

    public void addPages() {
        super.addPages();
        InputWizardSettings inputWizardSettingsMSD = InputWizardSettings.create((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"filterPathModelsMSD", (DataType[])new DataType[]{DataType.MSD});
        inputWizardSettingsMSD.setTitle("Open Chromatogram (MSD) File(s)");
        inputWizardSettingsMSD.setDescription("Select a chromatogram/chromatograms file to open.");
        InputWizardSettings inputWizardSettingsCSD = InputWizardSettings.create((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"filterPathModelsCSD", (DataType[])new DataType[]{DataType.CSD});
        inputWizardSettingsCSD.setTitle("Open Chromatogram (CSD) File(s)");
        inputWizardSettingsCSD.setDescription("Select a chromatogram/chromatograms file to open.");
        this.pageCalibrationSettings = new PageCalibrationSettings(this.wizardElements);
        this.pageInputEntriesMSD = new InputEntriesWizardPage(inputWizardSettingsMSD);
        this.pageInputEntriesCSD = new InputEntriesWizardPage(inputWizardSettingsCSD);
        this.pagePeakSelection = new PagePeakSelection(this.wizardElements);
        this.pagePeakAssignment = new PagePeakAssignment(this.wizardElements);
        this.pageCalibrationTable = new PageCalibrationTable(this.wizardElements);
        this.addPage((IWizardPage)this.pageCalibrationSettings);
        this.addPage((IWizardPage)this.pageInputEntriesMSD);
        this.addPage((IWizardPage)this.pageInputEntriesCSD);
        this.addPage((IWizardPage)this.pagePeakSelection);
        this.addPage((IWizardPage)this.pagePeakAssignment);
        this.addPage((IWizardPage)this.pageCalibrationTable);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = super.getNextPage(page);
        if (page == this.pageCalibrationSettings) {
            nextPage = this.wizardElements.isUseMassSpectrometryData() ? this.pageInputEntriesMSD : this.pageInputEntriesCSD;
        } else if (page == this.pageInputEntriesMSD) {
            nextPage = this.pagePeakSelection;
            this.wizardElements.clearSelectedChromatograms();
            ChromatogramWizardElements elements = new ChromatogramWizardElements();
            for (File file : this.pageInputEntriesMSD.getSelectedItems().keySet()) {
                elements.addSelectedChromatogram(file.getAbsolutePath());
            }
            this.wizardElements.addElements((IChromatogramWizardElements)elements);
            this.pageInputEntriesMSD.savePath();
        } else if (page == this.pageInputEntriesCSD) {
            nextPage = this.pagePeakSelection;
            this.wizardElements.clearSelectedChromatograms();
            ChromatogramWizardElements elements = new ChromatogramWizardElements();
            for (File file : this.pageInputEntriesCSD.getSelectedItems().keySet()) {
                elements.addSelectedChromatogram(file.getAbsolutePath());
            }
            this.wizardElements.addElements((IChromatogramWizardElements)elements);
            this.pageInputEntriesCSD.savePath();
        } else if (page == this.pagePeakSelection) {
            nextPage = this.pagePeakAssignment;
        } else if (page == this.pagePeakAssignment) {
            nextPage = this.pageCalibrationTable;
        } else if (page == this.pagePeakAssignment) {
            nextPage = this.pageCalibrationTable;
        } else if (page == this.pageCalibrationTable) {
            nextPage = null;
        }
        this.setPreviousPages();
        return nextPage;
    }

    private void setPreviousPages() {
        if (this.wizardElements.isUseMassSpectrometryData()) {
            this.pagePeakSelection.setPreviousPage((IWizardPage)this.pageInputEntriesMSD);
        } else {
            this.pagePeakSelection.setPreviousPage((IWizardPage)this.pageInputEntriesCSD);
        }
        this.pageCalibrationTable.setPreviousPage((IWizardPage)this.pagePeakAssignment);
        this.pagePeakAssignment.setPreviousPage((IWizardPage)this.pagePeakSelection);
        this.pageInputEntriesMSD.setPreviousPage((IWizardPage)this.pageCalibrationSettings);
        this.pageInputEntriesCSD.setPreviousPage((IWizardPage)this.pageCalibrationSettings);
    }

    public boolean canFinish() {
        boolean canFinish = this.pageCalibrationSettings.canFinish();
        if (canFinish) {
            if (this.wizardElements.isUseMassSpectrometryData()) {
                canFinish = this.wizardElements.getSelectedChromatograms().size() > 0;
            } else {
                boolean bl = canFinish = this.wizardElements.getSelectedChromatograms().size() > 0;
            }
        }
        if (canFinish) {
            canFinish = this.pagePeakSelection.canFinish();
        }
        if (canFinish) {
            canFinish = this.pagePeakAssignment.canFinish();
        }
        if (canFinish) {
            canFinish = this.wizardElements.isRetentionIndexDataValidated();
        }
        return canFinish;
    }

    public void doFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Create Chromatogram Evaluation", -1);
        IFile file = super.prepareProject(monitor);
        try {
            File calibrationFile = file.getLocation().toFile();
            if (!calibrationFile.getAbsolutePath().endsWith(CALIBRATION_FILE_EXTENSION)) {
                calibrationFile = new File(String.valueOf(calibrationFile.getAbsolutePath()) + CALIBRATION_FILE_EXTENSION);
            }
            CalibrationFileWriter calibrationFileWriter = new CalibrationFileWriter();
            calibrationFileWriter.write(calibrationFile, this.wizardElements.getSeparationColumnIndices());
            String path = calibrationFile.getAbsolutePath();
            File chromatogramFile = new File(String.valueOf(path.substring(0, path.length() - CALIBRATION_FILE_EXTENSION.length())) + CHROMATOGRAM_FILE_EXTENSION);
            IChromatogramSelection chromatogramSelection = this.wizardElements.getChromatogramSelection();
            if (this.wizardElements.isUseMassSpectrometryData()) {
                if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                    IChromatogramMSD chromatogramMSD = ((IChromatogramSelectionMSD)chromatogramSelection).getChromatogramMSD();
                    ChromatogramConverterMSD.getInstance().convert(chromatogramFile, (IChromatogram)chromatogramMSD, CHROMATOGRAM_CONVERTER_ID, monitor);
                }
            } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
                IChromatogramCSD chromatogramCSD = ((IChromatogramSelectionCSD)chromatogramSelection).getChromatogramCSD();
                ChromatogramConverterCSD.getInstance().convert(chromatogramFile, (IChromatogram)chromatogramCSD, CHROMATOGRAM_CONVERTER_ID, monitor);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        super.refreshWorkspace(monitor);
        super.runOpenEditor(file, monitor);
    }
}

