/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.internal.runnables.ChromatogramImportRunnable;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.ux.extension.xxd.ui.custom.ChromatogramPeakChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedScanChartUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.PeakTableRetentionIndexViewerUI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PagePeakSelection
extends AbstractExtendedWizardPage {
    private static final Logger logger = Logger.getLogger(PagePeakSelection.class);
    private IRetentionIndexWizardElements wizardElements;
    private ChromatogramPeakChart chromatogramPeakChart;
    private Composite massSpectrumComposite;
    private ExtendedScanChartUI extendedScanChartUI;
    private PeakTableRetentionIndexViewerUI peakTableViewerUI;
    private static final int PEAK_SHOW = 1;
    private static final int PEAKS_DELETE = 2;

    public PagePeakSelection(IRetentionIndexWizardElements wizardElements) {
        super(PagePeakSelection.class.getName());
        this.setTitle("Peak Selection");
        this.setDescription("Please select the peaks that shall be used.");
        this.wizardElements = wizardElements;
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
            this.wizardElements.setChromatogramSelection(chromatogramSelection);
            if (chromatogramSelection != null) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                boolean isVisible = chromatogram instanceof IChromatogramMSD;
                GridData gridData = (GridData)this.massSpectrumComposite.getLayoutData();
                gridData.exclude = !isVisible;
                this.massSpectrumComposite.setVisible(isVisible);
                Composite parent = this.massSpectrumComposite.getParent();
                parent.layout(false);
                parent.redraw();
                List peaks = chromatogram.getPeaks();
                this.peakTableViewerUI.setInput((Object)peaks);
                if (peaks.size() > 0) {
                    ArrayList<IPeak> selectedPeaks = new ArrayList<IPeak>();
                    IPeak selectedPeak = (IPeak)peaks.get(0);
                    selectedPeaks.add(selectedPeak);
                    chromatogramSelection.setSelectedPeak(selectedPeak);
                    this.updateChromatogramChart(chromatogramSelection);
                    this.updateSelectedPeaksInChart(selectedPeaks);
                    if (selectedPeak instanceof IPeakMSD) {
                        IPeakMSD peakMSD = (IPeakMSD)selectedPeak;
                        this.extendedScanChartUI.update((IScan)peakMSD.getExtractedMassSpectrum());
                    }
                }
            }
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createChromatogramField(composite);
        this.createMassSpectrumField(composite);
        this.createPeakTableField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createChromatogramField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.chromatogramPeakChart = new ChromatogramPeakChart(composite, 2048);
    }

    private void createMassSpectrumField(Composite parent) {
        this.massSpectrumComposite = new Composite(parent, 0);
        this.massSpectrumComposite.setLayoutData((Object)new GridData(1808));
        this.massSpectrumComposite.setLayout((Layout)new FillLayout());
        this.extendedScanChartUI = new ExtendedScanChartUI(this.massSpectrumComposite, null);
    }

    private void createPeakTableField(Composite parent) {
        this.peakTableViewerUI = new PeakTableRetentionIndexViewerUI(parent, 2050);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 100;
        this.peakTableViewerUI.getTable().setLayoutData((Object)gridData);
        this.peakTableViewerUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PagePeakSelection.this.propagateChange(1);
                PagePeakSelection.this.updateSelectedPeaksInChart(PagePeakSelection.this.getSelectionChromatogramPeakList());
            }
        });
        this.peakTableViewerUI.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && e.stateMask == 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                    messageBox.setText("Delete peak(s)");
                    messageBox.setMessage("Would you like to delete the selected peak(s)?");
                    if (messageBox.open() == 64) {
                        PagePeakSelection.this.propagateChange(2);
                    }
                }
            }
        });
    }

    private void propagateChange(int option) {
        Table table = this.peakTableViewerUI.getTable();
        int index = table.getSelectionIndex();
        Object object = this.peakTableViewerUI.getElementAt(index);
        IChromatogramSelection chromatogramSelection = this.wizardElements.getChromatogramSelection();
        if (chromatogramSelection != null && object instanceof IPeak) {
            IPeak selectedPeak = (IPeak)object;
            switch (option) {
                case 1: {
                    chromatogramSelection.setSelectedPeak(selectedPeak);
                    if (!(selectedPeak instanceof IPeakMSD)) break;
                    IPeakMSD peakMSD = (IPeakMSD)selectedPeak;
                    this.extendedScanChartUI.update((IScan)peakMSD.getExtractedMassSpectrum());
                    break;
                }
                case 2: {
                    List<IPeak> peaksToDelete = this.getSelectionChromatogramPeakList();
                    IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                    chromatogram.removePeaks(peaksToDelete);
                    chromatogramSelection.reset();
                    this.peakTableViewerUI.setInput((Object)chromatogram.getPeaks());
                    this.updateChromatogramChart(chromatogramSelection);
                    this.updateSelectedPeaksInChart(null);
                }
            }
        }
    }

    private IChromatogramSelection getChromatogramSelection() {
        ChromatogramSelectionMSD chromatogramSelection = null;
        ChromatogramImportRunnable runnable = new ChromatogramImportRunnable(this.wizardElements);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
            IChromatogram<? extends IPeak> chromatogram = runnable.getChromatogram();
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                chromatogramSelection = new ChromatogramSelectionMSD(chromatogramMSD);
            } else if (chromatogram instanceof IChromatogramCSD) {
                IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                chromatogramSelection = new ChromatogramSelectionCSD(chromatogramCSD);
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        return chromatogramSelection;
    }

    private List<IPeak> getSelectionChromatogramPeakList() {
        int[] indices;
        Table table = this.peakTableViewerUI.getTable();
        ArrayList<IPeak> peakList = new ArrayList<IPeak>();
        int[] nArray = indices = table.getSelectionIndices();
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IPeak) {
                IPeak chromatogramPeak = (IPeak)object;
                peakList.add(chromatogramPeak);
            }
            ++n2;
        }
        return peakList;
    }

    private void validateSelection() {
        IChromatogram chromatogram;
        String message = null;
        if (this.wizardElements.getSelectedChromatograms().size() == 0) {
            message = "No chromatogram has been selected.";
        }
        if (message == null && this.wizardElements.getChromatogramSelection() == null) {
            message = "The chromatogram couldn't be loaded.";
        }
        if (message == null && ((chromatogram = this.wizardElements.getChromatogramSelection().getChromatogram()) == null || chromatogram.getPeaks().size() == 0)) {
            message = "There is no peak available.";
        }
        this.updateStatus(message);
    }

    private void updateChromatogramChart(IChromatogramSelection chromatogramSelection) {
        this.chromatogramPeakChart.updateChromatogram(chromatogramSelection);
    }

    private void updateSelectedPeaksInChart(List<IPeak> selectedPeaks) {
        this.chromatogramPeakChart.updatePeaks(selectedPeaks);
    }
}

