/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IExtractionData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.PeakExtractionSupport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Samples;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class PcaExtractionPeaks
implements IExtractionData {
    private static final Logger logger = Logger.getLogger(PcaExtractionPeaks.class);
    private final List<IDataInputEntry> dataInputEntries;
    private final int retentionTimeWindow;

    public PcaExtractionPeaks(List<IDataInputEntry> dataInputEntries, int retentionTimeWindow) {
        this.retentionTimeWindow = retentionTimeWindow;
        this.dataInputEntries = dataInputEntries;
    }

    private Map<IDataInputEntry, IPeaks<?>> extractPeaks(List<IDataInputEntry> peakInputFiles, IProgressMonitor monitor) {
        LinkedHashMap peakMap = new LinkedHashMap();
        for (IDataInputEntry peakFile : peakInputFiles) {
            try {
                IProcessingInfo processingInfo = PeakConverterMSD.convert((File)new File(peakFile.getInputFile()), (IProgressMonitor)monitor);
                IPeaks peaks = (IPeaks)processingInfo.getProcessingResult();
                if (!peaks.isEmpty()) {
                    peakMap.put(peakFile, peaks);
                    continue;
                }
                logger.warn((Object)("No peaks contained in file: " + peakFile));
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        return peakMap;
    }

    @Override
    public Samples process(IProgressMonitor monitor) {
        PeakExtractionSupport peakExtractionSupport = new PeakExtractionSupport(this.retentionTimeWindow);
        Map<IDataInputEntry, IPeaks<?>> peakMap = this.extractPeaks(this.dataInputEntries, monitor);
        return peakExtractionSupport.extractPeakData(peakMap, monitor);
    }
}

