/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.massbank.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.io.AbstractMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.converter.supplier.massbank.model.VendorLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassBankReader
extends AbstractMassSpectraReader
implements IMassSpectraReader {
    private static final String TAG_DELIMITER = ":";
    private static final String SUB_TAG_DELIMITER = " ";
    private static final String COMMENT = "COMMENT";
    private static final String LICENSE = "LICENSE";
    private static final String COPYRIGHT = "COPYRIGHT";
    private static final String AUTHORS = "AUTHORS";
    private static final String CHEMICAL_NAME = "CH$NAME";
    private static final String CHEMICAL_LINK = "CH$LINK";
    private static final String CHEMICAL_COMPOUND_CLASS = "CH$COMPOUND_CLASS";
    private static final String PEAK_LIST_MARKER = "PK$PEAK";
    private static final String CHEMICAL_FORMULA = "CH$FORMULA";
    private static final String CHEMICAL_EXACT_MASS = "CH$EXACT_MASS";
    private static final String CHEMICAL_SMILES = "CH$SMILES";
    private static final String CHEMICAL_INCHI = "CH$IUPAC";
    private static final String MASS_SPECTROMETRY = "AC$MASS_SPECTROMETRY";
    private static final String MASSSPECTRUM_FOCUSED_ION = "MS$FOCUSED_ION";
    private static final Logger logger = Logger.getLogger(MassBankReader.class);

    public IMassSpectra read(File file, IProgressMonitor monitor) throws IOException {
        if (file.getName().toLowerCase().endsWith(".zip")) {
            if (monitor != null) {
                monitor.beginTask("Reading MassSpectras from " + file.getName(), -1);
            }
            MassSpectra massSpectra = new MassSpectra();
            massSpectra.setConverterId("MassBank");
            Throwable throwable = null;
            Object var5_9 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    IScanMSD spectrum;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".txt") || (spectrum = MassBankReader.readMassSpectrum(zipFile.getInputStream(entry), null)).getNumberOfIons() <= 0) continue;
                    massSpectra.addMassSpectrum(spectrum);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return massSpectra;
        }
        MassSpectra massSpectra = new MassSpectra();
        Throwable throwable = null;
        Object var5_11 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            IScanMSD spectrum = MassBankReader.readMassSpectrum(inputStream, monitor);
            if (spectrum.getNumberOfIons() > 0) {
                massSpectra.addMassSpectrum(spectrum);
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return massSpectra;
    }

    public static IScanMSD readMassSpectrum(InputStream stream, IProgressMonitor monitor) throws IOException {
        String line;
        VendorLibraryMassSpectrum massSpectrum = new VendorLibraryMassSpectrum();
        ILibraryInformation libraryInformation = massSpectrum.getLibraryInformation();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        block32: while ((line = bufferedReader.readLine()) != null) {
            String[] values;
            if (line.startsWith(PEAK_LIST_MARKER) && (line = MassBankReader.parsePeakList(bufferedReader, massSpectrum)) == null || (values = line.split(TAG_DELIMITER, 2)).length != 2) continue;
            String key = values[0].trim();
            String value = values[1].trim();
            switch (key) {
                case "COPYRIGHT": {
                    MassBankReader.addMisc(libraryInformation, "copyright: " + value);
                    break;
                }
                case "LICENSE": {
                    MassBankReader.addMisc(libraryInformation, "license: " + value);
                    break;
                }
                case "COMMENT": {
                    MassBankReader.addComment(libraryInformation, value);
                    break;
                }
                case "CH$FORMULA": {
                    libraryInformation.setFormula(value);
                    break;
                }
                case "CH$SMILES": {
                    libraryInformation.setSmiles(value);
                    break;
                }
                case "CH$NAME": {
                    libraryInformation.setName(value);
                    break;
                }
                case "CH$IUPAC": {
                    libraryInformation.setInChI(value);
                    break;
                }
                case "AC$MASS_SPECTROMETRY": {
                    MassBankReader.parseMassSpectrometrySubTag(value.trim(), massSpectrum);
                    break;
                }
                case "CH$LINK": {
                    MassBankReader.parseLinkSubTag(value, massSpectrum);
                    break;
                }
                case "MS$FOCUSED_ION": {
                    MassBankReader.parseFocusedIonSubTag(value.trim(), massSpectrum);
                    break;
                }
                case "CH$COMPOUND_CLASS": {
                    libraryInformation.addClassifier(value);
                    break;
                }
                case "AUTHORS": {
                    libraryInformation.setContributor(value);
                    break;
                }
                case "CH$EXACT_MASS": {
                    try {
                        libraryInformation.setMolWeight(Double.parseDouble(value));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block32;
                }
            }
        }
        bufferedReader.close();
        return massSpectrum;
    }

    private static void addMisc(ILibraryInformation libraryInformation, String value) {
        String miscellaneous = libraryInformation.getMiscellaneous();
        if (miscellaneous != null && !miscellaneous.isEmpty()) {
            libraryInformation.setMiscellaneous(String.valueOf(miscellaneous) + ", " + value);
        } else {
            libraryInformation.setMiscellaneous(value);
        }
    }

    private static void addComment(ILibraryInformation libraryInformation, String value) {
        String comments = libraryInformation.getComments();
        if (comments != null && comments.length() > 0) {
            libraryInformation.setComments(String.valueOf(comments) + ", " + value);
        } else {
            libraryInformation.setComments(value);
        }
    }

    private static String parsePeakList(BufferedReader bufferedReader, VendorLibraryMassSpectrum massSpectrum) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            if (!line.startsWith("  ")) break;
            String[] values = line.trim().split(SUB_TAG_DELIMITER);
            if (values.length != 3) continue;
            try {
                double mz = Double.parseDouble(values[0]);
                float abundance = Float.parseFloat(values[1]);
                Ion ion = new Ion(mz, abundance);
                massSpectrum.addIon((IIon)ion);
            }
            catch (Exception e) {
                logger.warn((Object)("Parsing peak line failed: " + e));
            }
        }
        return line;
    }

    private static void parseLinkSubTag(String subtag, VendorLibraryMassSpectrum massSpectrum) {
        String[] split = subtag.split(SUB_TAG_DELIMITER, 2);
        if (split.length == 2) {
            String tag = split[0].trim();
            String value = split[1].trim();
            if ("CAS".equals(tag)) {
                massSpectrum.getLibraryInformation().setCasNumber(value);
            } else if ("INCHIKEY".equals(tag)) {
                massSpectrum.getLibraryInformation().setInChI(value);
            }
        }
    }

    private static void parseFocusedIonSubTag(String subtag, VendorLibraryMassSpectrum massSpectrum) {
        String[] split = subtag.split(SUB_TAG_DELIMITER, 2);
        if (split.length == 2) {
            String tag = split[0].trim();
            String value = split[1].trim();
            if ("PRECURSOR_M/Z".equals(tag)) {
                try {
                    massSpectrum.setPrecursorIon(Double.parseDouble(value));
                }
                catch (RuntimeException runtimeException) {}
            } else if ("PRECURSOR_TYPE".equals(tag)) {
                massSpectrum.setPrecursorType(value);
            } else if ("BASE_PEAK".equals(tag)) {
                try {
                    massSpectrum.setPrecursorBasepeak(Double.parseDouble(value));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private static void parseMassSpectrometrySubTag(String subtag, VendorLibraryMassSpectrum massSpectrum) {
        String[] split = subtag.split(SUB_TAG_DELIMITER, 2);
        if (split.length == 2) {
            String tag = split[0].trim();
            String value = split[1].trim();
            if ("MS_TYPE".equals(tag)) {
                try {
                    massSpectrum.setMassSpectrometer(Short.parseShort(value.substring(2)));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }
}

