/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.massbank.converter;

import java.io.File;
import java.io.IOException;
import org.eclipse.chemclipse.msd.converter.database.IDatabaseImportConverter;
import org.eclipse.chemclipse.msd.converter.massspectrum.IMassSpectrumImportConverter;
import org.eclipse.chemclipse.msd.converter.supplier.massbank.io.MassBankReader;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassBankImportConverter
implements IDatabaseImportConverter,
IMassSpectrumImportConverter {
    private static final String DESCRIPTION = "MassBank MassSpectrum Import";

    public IProcessingInfo<IMassSpectra> convert(File file, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        try {
            MassBankReader massSpectraReader = new MassBankReader();
            IMassSpectra massSpectra = massSpectraReader.read(file, monitor);
            if (massSpectra != null && massSpectra.size() > 0) {
                processingInfo.setProcessingResult((Object)massSpectra);
            } else {
                processingInfo.addErrorMessage(DESCRIPTION, "No mass spectra are stored in" + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            processingInfo.addErrorMessage(DESCRIPTION, "Error reading file: " + file.getAbsolutePath(), (Throwable)e);
        }
        return processingInfo;
    }
}

