/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;

public class AqlResolverURIHandler
implements URIHandler {
    private static final String NOT_IMPLEMENTED = "Not implemented.";
    private static final String AQL_RESOLVE_PROTOCOL = "aqlresolve";
    private static final String RESOURCE_HOST = "resource";
    private final IQualifiedNameResolver resolver;

    public AqlResolverURIHandler(IQualifiedNameResolver resolver) {
        this.resolver = resolver;
    }

    public boolean canHandle(URI uri) {
        return AqlResolverURIHandler.isAqlResolveURI(uri);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        InputStream res = AqlResolverURIHandler.isResourceURI(uri) ? this.resolver.getInputStream(AqlResolverURIHandler.getResourceName(uri)) : null;
        if (res == null) {
            throw new IOException("No rersource " + uri.toString());
        }
        return res;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return null;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        boolean res;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = this.createInputStream(uri, null);){
                res = is != null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return null;
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public static String getResourceName(URI uri) {
        String path;
        String res = AqlResolverURIHandler.isAqlResolveURI(uri) ? ((path = uri.path()) != null && !path.isEmpty() ? path.substring(1) : null) : null;
        return res;
    }

    private static boolean isAqlResolveURI(URI uri) {
        String host;
        boolean res = AQL_RESOLVE_PROTOCOL.equals(uri.scheme().toLowerCase()) ? ((host = uri.host()) != null ? AqlResolverURIHandler.isResourceURI(uri) : false) : false;
        return res;
    }

    private static boolean isResourceURI(URI uri) {
        return RESOURCE_HOST.equals(uri.host().toLowerCase());
    }

    public static URI createAqlResourceResolverURI(String resourceName) {
        return URI.createURI((String)("aqlresolve://resource/" + resourceName));
    }
}

