/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventMotion;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    long defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;
    private static final int DEFAULT_CROSS_AXIS_SIZE = 3;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int border = this.getBorderWidthInPixels();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_widget_set_focusable(this.handle, true);
            this.defaultCursor = (this.style & 0x200) != 0 ? GDK.gdk_cursor_new_from_name("sb_h_double_arrow", 0L) : GDK.gdk_cursor_new_from_name("sb_v_double_arrow", 0L);
        } else {
            GTK3.gtk_widget_set_has_window(this.handle, true);
            this.defaultCursor = (this.style & 0x200) != 0 ? GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "sb_h_double_arrow") : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "sb_v_double_arrow");
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
    }

    @Override
    int gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        int result = super.gtk_gesture_press_event(gesture, n_press, x, y, event);
        int eventButton = GDK.gdk_button_event_get_button(event);
        if (eventButton != 1 || n_press != 1) {
            return result;
        }
        this.startX = (int)x;
        this.startY = (int)y;
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        int allocationX = allocation.x;
        int allocationY = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        this.lastX = allocationX;
        this.lastY = allocationY;
        Event jEvent = new Event();
        jEvent.time = GDK.gdk_event_get_time(event);
        Rectangle eventRect = new Rectangle(this.lastX, this.lastY, width, height);
        jEvent.setBounds(eventRect);
        if ((this.style & 0x10000) == 0) {
            jEvent.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            jEvent.x = this.parent.getClientWidth() - width - jEvent.x;
        }
        this.sendSelectionEvent(13, jEvent, true);
        if (this.isDisposed()) {
            return result;
        }
        if (jEvent.doit) {
            this.dragging = true;
        }
        return result;
    }

    @Override
    int gtk_gesture_release_event(long gesture, int n_press, double x, double y, long event) {
        int result = super.gtk_gesture_release_event(gesture, n_press, x, y, event);
        int eventButton = GDK.gdk_button_event_get_button(event);
        if (eventButton != 1 || !this.dragging) {
            return result;
        }
        this.dragging = false;
        return result;
    }

    @Override
    void gtk4_motion_event(long controller, double x, double y, long event) {
        super.gtk4_motion_event(controller, x, y, event);
        if (!this.dragging) {
            return;
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        int allocationX = allocation.x;
        int allocationY = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        GTK.gtk_widget_get_allocation(this.parent.handle, allocation);
        int parentWidth = allocation.width;
        int parentHeight = allocation.height;
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, (int)x + allocationX - this.startX), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, (int)y + allocationY - this.startY), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return;
        }
        Event jEvent = new Event();
        jEvent.time = GDK.gdk_event_get_time(event);
        Rectangle eventRect = new Rectangle(newX, newY, width, height);
        jEvent.setBounds(eventRect);
        if ((this.style & 0x10000) == 0) {
            jEvent.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            jEvent.x = this.parent.getClientWidth() - width - jEvent.x;
        }
        this.sendSelectionEvent(13, jEvent, true);
        if (this.isDisposed()) {
            return;
        }
        Rectangle rect = jEvent.getBounds();
        if (jEvent.doit) {
            this.lastX = rect.x;
            this.lastY = rect.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        if ((this.style & 0x10000) != 0) {
            this.setBoundsInPixels(this.lastX, this.lastY, width, height);
        }
    }

    @Override
    boolean gtk4_key_press_event(long controller, int keyval, int keycode, int state, long event) {
        boolean handled = super.gtk4_key_press_event(controller, keyval, keycode, state, event);
        if (!handled) {
            return handled;
        }
        switch (keyval) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                if ((state & 4) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyval == 65362 || keyval == 65364) break;
                    xChange = keyval == 65361 ? -stepSize : stepSize;
                } else {
                    if (keyval == 65361 || keyval == 65363) break;
                    yChange = keyval == 65362 ? -stepSize : stepSize;
                }
                GtkAllocation allocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(this.handle, allocation);
                int width = allocation.width;
                int height = allocation.height;
                GTK.gtk_widget_get_allocation(this.parent.handle, allocation);
                int parentWidth = allocation.width;
                int parentHeight = allocation.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return handled;
                }
                Event jEvent = new Event();
                jEvent.time = GDK.gdk_event_get_time(event);
                Rectangle eventRect = new Rectangle(newX, newY, width, height);
                jEvent.setBounds(eventRect);
                if ((this.parent.style & 0x8000000) != 0) {
                    jEvent.x = this.parent.getClientWidth() - width - jEvent.x;
                }
                this.sendSelectionEvent(13, jEvent, true);
                if (this.isDisposed() || !jEvent.doit) break;
                Rectangle rect = jEvent.getBounds();
                this.lastX = rect.x;
                this.lastY = rect.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - width - this.lastX;
                }
                if ((this.style & 0x10000) == 0) break;
                this.setBoundsInPixels(rect.x, rect.y, width, height);
                if (!this.isDisposed()) break;
            }
        }
        return handled;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int[] eventButton = new int[1];
        GDK.gdk_event_get_button(event, eventButton);
        if (eventButton[0] != 1) {
            return 0L;
        }
        int eventType = GDK.gdk_event_get_event_type(event);
        if (eventType == 5) {
            return 0L;
        }
        if (eventType == 6) {
            return 0L;
        }
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        long window = this.gtk_widget_get_window(widget);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        GDK.gdk_window_get_origin(window, origin_x, origin_y);
        this.startX = (int)(eventRX[0] - (double)origin_x[0]);
        this.startY = (int)(eventRY[0] - (double)origin_y[0]);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        this.lastX = x;
        this.lastY = y;
        Event jEvent = new Event();
        jEvent.time = GDK.gdk_event_get_time(event);
        Rectangle eventRect = new Rectangle(this.lastX, this.lastY, width, height);
        jEvent.setBounds(eventRect);
        if ((this.style & 0x10000) == 0) {
            jEvent.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            jEvent.x = this.parent.getClientWidth() - width - jEvent.x;
        }
        this.sendSelectionEvent(13, jEvent, true);
        if (this.isDisposed()) {
            return 0L;
        }
        if (jEvent.doit) {
            this.dragging = true;
            Rectangle rect = jEvent.getBounds();
            this.lastX = rect.x;
            this.lastY = rect.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
            this.parent.update(true, (this.style & 0x10000) == 0);
            if ((this.style & 0x10000) != 0) {
                this.setBoundsInPixels(rect.x, rect.y, width, height);
            }
        }
        return result;
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        long result = super.gtk_button_release_event(widget, event);
        if (result != 0L) {
            return result;
        }
        int[] eventButton = new int[1];
        GDK.gdk_event_get_button(event, eventButton);
        if (eventButton[0] != 1 || !this.dragging) {
            return 0L;
        }
        this.dragging = false;
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        Event jEvent = new Event();
        jEvent.time = GDK.gdk_event_get_time(event);
        Rectangle eventRect = new Rectangle(this.lastX, this.lastY, width, height);
        jEvent.setBounds(eventRect);
        if ((this.parent.style & 0x8000000) != 0) {
            jEvent.x = this.parent.getClientWidth() - width - jEvent.x;
        }
        this.sendSelectionEvent(13, jEvent, true);
        if (this.isDisposed()) {
            return result;
        }
        if (jEvent.doit && (this.style & 0x10000) != 0) {
            Rectangle rect = jEvent.getBounds();
            this.setBoundsInPixels(rect.x, rect.y, width, height);
        }
        return result;
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        long context = GTK.gtk_widget_get_style_context(widget);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        GTK.gtk_render_background(context, cairo, 0.0, 0.0, width, height);
        return super.gtk_draw(widget, cairo);
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if (this.handle != 0L) {
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.handle, allocation);
            this.lastX = allocation.x;
            this.lastY = allocation.y;
        }
        return 0L;
    }

    @Override
    long gtk3_key_press_event(long widget, long eventPtr) {
        long result = super.gtk3_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        int[] key = new int[1];
        int[] state = new int[1];
        GDK.gdk_event_get_keyval(eventPtr, key);
        GDK.gdk_event_get_state(eventPtr, state);
        switch (key[0]) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                if ((state[0] & 4) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (key[0] == 65362 || key[0] == 65364) break;
                    xChange = key[0] == 65361 ? -stepSize : stepSize;
                } else {
                    if (key[0] == 65361 || key[0] == 65363) break;
                    yChange = key[0] == 65362 ? -stepSize : stepSize;
                }
                GtkAllocation allocation = new GtkAllocation();
                GTK.gtk_widget_get_allocation(this.handle, allocation);
                int width = allocation.width;
                int height = allocation.height;
                GTK.gtk_widget_get_allocation(this.parent.handle, allocation);
                int parentWidth = allocation.width;
                int parentHeight = allocation.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                long gdkResource = this.gtk_widget_get_window(this.handle);
                int grabMask = 516;
                long gdkCursor = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int ptrGrabResult = this.gdk_pointer_grab(gdkResource, 0, false, grabMask, gdkResource, gdkCursor, 0);
                Event event = new Event();
                event.time = GDK.gdk_event_get_time(eventPtr);
                Rectangle eventRect = new Rectangle(newX, newY, width, height);
                event.setBounds(eventRect);
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = this.parent.getClientWidth() - width - event.x;
                }
                this.sendSelectionEvent(13, event, true);
                if (ptrGrabResult == 0) {
                    this.gdk_pointer_ungrab(gdkResource, 0);
                }
                if (this.isDisposed() || !event.doit) break;
                Rectangle rect = event.getBounds();
                this.lastX = rect.x;
                this.lastY = rect.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - width - this.lastX;
                }
                if ((this.style & 0x10000) != 0) {
                    this.setBoundsInPixels(rect.x, rect.y, width, height);
                    if (this.isDisposed()) break;
                }
                int cursorX = rect.x;
                int cursorY = rect.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    @Override
    long gtk_motion_notify_event(long widget, long eventPtr) {
        int eventState;
        int eventY;
        int eventX;
        boolean isHint;
        long result = super.gtk_motion_notify_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        if (!this.dragging) {
            return 0L;
        }
        double[] fetchedX = new double[1];
        double[] fetchedY = new double[1];
        GDK.gdk_event_get_root_coords(eventPtr, fetchedX, fetchedY);
        int[] state = new int[1];
        GDK.gdk_event_get_state(eventPtr, state);
        long gdkResource = this.gdk_event_get_surface_or_window(eventPtr);
        GdkEventMotion gdkEvent = new GdkEventMotion();
        GTK3.memmove(gdkEvent, eventPtr, (long)GdkEventMotion.sizeof);
        boolean bl = isHint = gdkEvent.is_hint != 0;
        if (isHint) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            int[] mask = new int[1];
            this.display.getWindowPointerPosition(gdkResource, pointer_x, pointer_y, mask);
            eventX = pointer_x[0];
            eventY = pointer_y[0];
            eventState = mask[0];
        } else {
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            GDK.gdk_window_get_origin(gdkResource, origin_x, origin_y);
            eventX = (int)(fetchedX[0] - (double)origin_x[0]);
            eventY = (int)(fetchedY[0] - (double)origin_y[0]);
            eventState = state[0];
        }
        if ((eventState & 0x100) == 0) {
            return 0L;
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        GTK.gtk_widget_get_allocation(this.parent.handle, allocation);
        int parentWidth = allocation.width;
        int parentHeight = allocation.height;
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, eventX + x - this.startX), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, eventY + y - this.startY), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return 0L;
        }
        Event event = new Event();
        event.time = GDK.gdk_event_get_time(eventPtr);
        Rectangle eventRect = new Rectangle(newX, newY, width, height);
        event.setBounds(eventRect);
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - width - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        Rectangle rect = event.getBounds();
        if (event.doit) {
            this.lastX = rect.x;
            this.lastY = rect.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        if ((this.style & 0x10000) != 0) {
            this.setBoundsInPixels(this.lastX, this.lastY, width, height);
        }
        return result;
    }

    @Override
    long gtk_realize(long widget) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0L);
        return super.gtk_realize(widget);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (!GTK.GTK4) {
            GTK3.gtk_widget_add_events(this.handle, 8);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0L) {
            OS.g_object_unref(this.defaultCursor);
        }
        this.defaultCursor = 0L;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void setCursor(long cursor) {
        super.setCursor(cursor != 0L ? cursor : this.defaultCursor);
    }

    @Override
    int traversalCode(int key, long event) {
        return 0;
    }
}

